/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.TimestampParser;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.util.DataTypeUtils;

public class NiFiRecordSerDe
extends AbstractSerDe {
    protected RecordReader recordReader;
    protected ComponentLog log;
    protected List<String> columnNames;
    protected StructTypeInfo schema;
    protected SerDeStats stats;
    protected StandardStructObjectInspector cachedObjectInspector;
    protected TimestampParser tsParser;
    private static final Pattern INTERNAL_PATTERN = Pattern.compile("_col([0-9]+)");
    private Map<String, Integer> fieldPositionMap;

    public NiFiRecordSerDe(RecordReader recordReader, ComponentLog log) {
        this.recordReader = recordReader;
        this.log = log;
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        StructTypeInfo rowTypeInfo;
        this.log.debug("Initializing NiFiRecordSerDe: {}", tbl.entrySet().toArray());
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        String columnNameDelimiter = tbl.containsKey("column.name.delimiter") ? tbl.getProperty("column.name.delimiter") : String.valueOf(',');
        this.columnNames = columnNameProperty.isEmpty() ? new ArrayList<String>(0) : new ArrayList<String>(Arrays.asList(columnNameProperty.split(columnNameDelimiter)));
        ArrayList columnTypes = columnTypeProperty.isEmpty() ? new ArrayList(0) : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        this.log.debug("columns: {}, {}", new Object[]{columnNameProperty, this.columnNames});
        this.log.debug("types: {}, {} ", new Object[]{columnTypeProperty, columnTypes});
        assert (this.columnNames.size() == columnTypes.size());
        this.schema = rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, columnTypes);
        this.log.debug("schema : {}", new Object[]{this.schema});
        this.cachedObjectInspector = (StandardStructObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)rowTypeInfo);
        this.tsParser = new TimestampParser(HiveStringUtils.splitAndUnEscape((String)tbl.getProperty("timestamp.formats")));
        try {
            this.populateFieldPositionMap();
        }
        catch (IOException | MalformedRecordException e) {
            throw new SerDeException(e);
        }
        this.stats = new SerDeStats();
    }

    public Class<? extends Writable> getSerializedClass() {
        return ObjectWritable.class;
    }

    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        throw new UnsupportedOperationException("This SerDe only supports deserialization");
    }

    public SerDeStats getSerDeStats() {
        return this.stats;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        ObjectWritable t = (ObjectWritable)writable;
        Record record = (Record)t.get();
        ArrayList<Object> r = new ArrayList<Object>(Collections.nCopies(this.columnNames.size(), null));
        try {
            RecordSchema recordSchema = record.getSchema();
            for (RecordField field : recordSchema.getFields()) {
                String fieldName = field.getFieldName();
                String normalizedFieldName = fieldName.toLowerCase();
                Integer fpos = this.fieldPositionMap.get(normalizedFieldName);
                if (fpos == null || fpos == -1) continue;
                Object currField = this.extractCurrentField(record, field, this.schema.getStructFieldTypeInfo(normalizedFieldName));
                r.set(fpos, currField);
            }
            this.stats.setRowCount(this.stats.getRowCount() + 1L);
        }
        catch (Exception e) {
            this.log.warn("Error [{}] parsing Record [{}].", new Object[]{e.toString(), t}, (Throwable)e);
            throw new SerDeException((Throwable)e);
        }
        return r;
    }

    private Object extractCurrentField(Record record, RecordField field, TypeInfo fieldTypeInfo) throws SerDeException {
        Object val;
        if (field == null) {
            return null;
        }
        String fieldName = field.getFieldName();
        block1 : switch (fieldTypeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN;
                if (fieldTypeInfo instanceof PrimitiveTypeInfo) {
                    primitiveCategory = ((PrimitiveTypeInfo)fieldTypeInfo).getPrimitiveCategory();
                }
                switch (primitiveCategory) {
                    case BYTE: {
                        Integer bIntValue = record.getAsInt(fieldName);
                        val = bIntValue == null ? null : Byte.valueOf(bIntValue.byteValue());
                        break block1;
                    }
                    case SHORT: {
                        Integer sIntValue = record.getAsInt(fieldName);
                        val = sIntValue == null ? null : Short.valueOf(sIntValue.shortValue());
                        break block1;
                    }
                    case INT: {
                        val = record.getAsInt(fieldName);
                        break block1;
                    }
                    case LONG: {
                        val = record.getAsLong(fieldName);
                        break block1;
                    }
                    case BOOLEAN: {
                        val = record.getAsBoolean(fieldName);
                        break block1;
                    }
                    case FLOAT: {
                        val = record.getAsFloat(fieldName);
                        break block1;
                    }
                    case DOUBLE: {
                        val = record.getAsDouble(fieldName);
                        break block1;
                    }
                    case STRING: 
                    case VARCHAR: 
                    case CHAR: {
                        val = record.getAsString(fieldName);
                        break block1;
                    }
                    case BINARY: {
                        Object[] array = record.getAsArray(fieldName);
                        if (array == null) {
                            return null;
                        }
                        val = AvroTypeUtil.convertByteArray((Object[])array).array();
                        break block1;
                    }
                    case DATE: {
                        java.util.Date d = record.getAsDate(fieldName, field.getDataType().getFormat());
                        if (d != null) {
                            Date hiveDate = new Date();
                            hiveDate.setTimeInMillis(d.getTime());
                            val = hiveDate;
                            break block1;
                        }
                        val = null;
                        break block1;
                    }
                    case TIMESTAMP: {
                        Timestamp ts = DataTypeUtils.toTimestamp((Object)record.getValue(fieldName), () -> DataTypeUtils.getDateFormat((String)field.getDataType().getFormat()), (String)fieldName);
                        if (ts != null) {
                            org.apache.hadoop.hive.common.type.Timestamp hivetimestamp = new org.apache.hadoop.hive.common.type.Timestamp();
                            hivetimestamp.setTimeInMillis(ts.getTime(), ts.getNanos());
                            val = hivetimestamp;
                            break block1;
                        }
                        val = null;
                        break block1;
                    }
                    case DECIMAL: {
                        Double value = record.getAsDouble(fieldName);
                        val = value == null ? null : HiveDecimal.create((double)value);
                        break block1;
                    }
                }
                throw new IllegalArgumentException("Field " + fieldName + " cannot be converted to type: " + primitiveCategory.name());
            }
            case LIST: {
                Object[] value = record.getAsArray(fieldName);
                val = value == null ? null : Arrays.asList(value);
                break;
            }
            case MAP: {
                val = record.getValue(fieldName);
                break;
            }
            case STRUCT: {
                Record nestedRecord = (Record)record.getValue(fieldName);
                if (nestedRecord == null) {
                    return null;
                }
                try {
                    RecordSchema recordSchema = nestedRecord.getSchema();
                    List recordFields = recordSchema.getFields();
                    if (recordFields == null || recordFields.isEmpty()) {
                        return Collections.emptyList();
                    }
                    ArrayList<Object> structList = new ArrayList<Object>(recordFields.size());
                    StructTypeInfo typeInfo = (StructTypeInfo)this.schema.getStructFieldTypeInfo(fieldName);
                    for (RecordField nestedRecordField : recordFields) {
                        String fName = nestedRecordField.getFieldName();
                        String normalizedFieldName = fName.toLowerCase();
                        structList.add(this.extractCurrentField(nestedRecord, nestedRecordField, typeInfo.getStructFieldTypeInfo(normalizedFieldName)));
                    }
                    return structList;
                }
                catch (Exception e) {
                    this.log.warn("Error [{}] parsing Record [{}].", new Object[]{e.toString(), nestedRecord}, (Throwable)e);
                    throw new SerDeException((Throwable)e);
                }
            }
            default: {
                this.log.error("Unknown type found: " + fieldTypeInfo + "for field of type: " + field.getDataType().toString());
                return null;
            }
        }
        return val;
    }

    public ObjectInspector getObjectInspector() {
        return this.cachedObjectInspector;
    }

    private void populateFieldPositionMap() throws MalformedRecordException, IOException {
        this.fieldPositionMap = new HashMap<String, Integer>(this.columnNames.size());
        RecordSchema recordSchema = this.recordReader.getSchema();
        for (RecordField field : recordSchema.getFields()) {
            String fieldName = field.getFieldName();
            String normalizedFieldName = fieldName.toLowerCase();
            int fpos = this.schema.getAllStructFieldNames().indexOf(fieldName.toLowerCase());
            if (fpos == -1) {
                Matcher m = INTERNAL_PATTERN.matcher(fieldName);
                fpos = m.matches() ? Integer.parseInt(m.group(1)) : -1;
                this.log.debug("NPE finding position for field [{}] in schema [{}], attempting to check if it is an internal column name like _col0", new Object[]{fieldName, this.schema});
                if (fpos == -1) {
                    this.log.debug("Field {} is not found in the target table, ignoring...", new Object[]{field.getFieldName()});
                    continue;
                }
                if (!fieldName.equalsIgnoreCase(HiveConf.getColumnInternalName((int)fpos))) {
                    this.log.error("Hive internal column name {} and position encoding {} for the column name are at odds", new Object[]{fieldName, fpos});
                    throw new IOException("Hive internal column name (" + fieldName + ") and position encoding (" + fpos + ") for the column name are at odds");
                }
            }
            this.fieldPositionMap.put(normalizedFieldName, fpos);
        }
    }
}

