/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.orc.record;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.orc.NiFiOrcUtils;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.nifi.processors.hadoop.record.HDFSRecordWriter;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.DataType;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class ORCHDFSRecordWriter
implements HDFSRecordWriter {
    private final RecordSchema recordSchema;
    private final TypeInfo orcSchema;
    private final Writer orcWriter;
    private final String hiveTableName;
    private final boolean hiveFieldNames;
    private final List<RecordField> recordFields;
    private final int numRecordFields;
    private Object[] workingRow;

    public ORCHDFSRecordWriter(Writer orcWriter, RecordSchema recordSchema, String hiveTableName, boolean hiveFieldNames) {
        this.recordSchema = recordSchema;
        this.orcWriter = orcWriter;
        this.hiveFieldNames = hiveFieldNames;
        this.orcSchema = NiFiOrcUtils.getOrcSchema(recordSchema, this.hiveFieldNames);
        this.hiveTableName = hiveTableName;
        this.recordFields = recordSchema != null ? recordSchema.getFields() : null;
        this.numRecordFields = this.recordFields != null ? this.recordFields.size() : -1;
        this.workingRow = this.numRecordFields > -1 ? new Object[this.numRecordFields] : null;
    }

    public void write(Record record) throws IOException {
        if (this.recordFields != null) {
            for (int i = 0; i < this.numRecordFields; ++i) {
                RecordField field = this.recordFields.get(i);
                DataType fieldType = field.getDataType();
                String fieldName = field.getFieldName();
                Object o = record.getValue(field);
                try {
                    this.workingRow[i] = NiFiOrcUtils.convertToORCObject(NiFiOrcUtils.getOrcField(fieldType, this.hiveFieldNames), o, this.hiveFieldNames);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    String errorMsg = "Index out of bounds for column " + i + ", type " + fieldName + ", and object " + o.toString();
                    throw new IOException(errorMsg, aioobe);
                }
            }
            this.orcWriter.addRow((Object)NiFiOrcUtils.createOrcStruct(this.orcSchema, this.workingRow));
        }
    }

    public WriteResult write(RecordSet recordSet) throws IOException {
        Record record;
        int recordCount = 0;
        while ((record = recordSet.next()) != null) {
            this.write(record);
            ++recordCount;
        }
        final String hiveDDL = NiFiOrcUtils.generateHiveDDL(this.recordSchema, this.hiveTableName, this.hiveFieldNames);
        HashMap<String, String> attributes = new HashMap<String, String>(){
            {
                this.put("hive.ddl", hiveDDL);
            }
        };
        return WriteResult.of((int)recordCount, (Map)attributes);
    }

    public void close() throws IOException {
        this.orcWriter.close();
    }
}

