/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;

public class HiveOptions
implements Serializable {
    protected String databaseName;
    protected String tableName;
    protected String metaStoreURI;
    protected Integer idleTimeout = 60000;
    protected Integer callTimeout = 0;
    protected List<String> staticPartitionValues = null;
    protected Boolean autoCreatePartitions = true;
    protected String kerberosPrincipal;
    protected String kerberosKeytab;
    protected HiveConf hiveConf;
    protected boolean streamingOptimizations = true;

    public HiveOptions(String metaStoreURI, String databaseName, String tableName) {
        this.metaStoreURI = metaStoreURI;
        this.databaseName = databaseName;
        this.tableName = tableName;
    }

    public HiveOptions withCallTimeout(Integer callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public HiveOptions withStaticPartitionValues(List<String> staticPartitionValues) {
        this.staticPartitionValues = staticPartitionValues;
        return this;
    }

    public HiveOptions withAutoCreatePartitions(Boolean autoCreatePartitions) {
        this.autoCreatePartitions = autoCreatePartitions;
        return this;
    }

    public HiveOptions withKerberosKeytab(String kerberosKeytab) {
        this.kerberosKeytab = kerberosKeytab;
        return this;
    }

    public HiveOptions withKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
        return this;
    }

    public HiveOptions withHiveConf(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        return this;
    }

    public HiveOptions withStreamingOptimizations(boolean streamingOptimizations) {
        this.streamingOptimizations = streamingOptimizations;
        return this;
    }

    public String getMetaStoreURI() {
        return this.metaStoreURI;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQualifiedTableName() {
        return this.databaseName + "." + this.tableName;
    }

    public List<String> getStaticPartitionValues() {
        return this.staticPartitionValues;
    }

    public Integer getCallTimeOut() {
        return this.callTimeout;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public boolean getStreamingOptimizations() {
        return this.streamingOptimizations;
    }
}

