/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.File;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveUtils.class);
    public static final Validator GREATER_THAN_ONE_VALIDATOR = (subject, value, context) -> {
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(value)) {
            return new ValidationResult.Builder().subject(subject).input(value).explanation("Expression Language Present").valid(true).build();
        }
        String reason = null;
        try {
            int intVal = Integer.parseInt(value);
            if (intVal < 2) {
                reason = "value is less than 2";
            }
        }
        catch (NumberFormatException e) {
            reason = "value is not a valid integer";
        }
        return new ValidationResult.Builder().subject(subject).input(value).explanation(reason).valid(reason == null).build();
    };

    public static Validator createMultipleFilesExistValidator() {
        return (subject, input, context) -> {
            String[] files;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            for (String filename : files = input.split("\\s*,\\s*")) {
                try {
                    boolean valid;
                    File file = new File(filename.trim());
                    boolean bl = valid = file.exists() && file.isFile();
                    if (valid) continue;
                    String message = "File " + file + " does not exist or is not a file";
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(message).build();
                }
                catch (SecurityException e) {
                    String message = "Unable to access " + filename + " due to " + e.getMessage();
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(message).build();
                }
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
        };
    }
}

