/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hive;

import java.io.File;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class HiveUtils {
    public static Validator createMultipleFilesExistValidator() {
        return (subject, input, context) -> {
            String[] files;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            for (String filename : files = input.split("\\s*,\\s*")) {
                try {
                    boolean valid;
                    File file = new File(filename.trim());
                    boolean bl = valid = file.exists() && file.isFile();
                    if (valid) continue;
                    String message = "File " + file + " does not exist or is not a file";
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(message).build();
                }
                catch (SecurityException e) {
                    String message = "Unable to access " + filename + " due to " + e.getMessage();
                    return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(message).build();
                }
            }
            return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
        };
    }
}

