/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.influxdb;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;

public abstract class AbstractInfluxDBProcessor
extends AbstractProcessor {
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("influxdb-charset").displayName("Character Set").description("Specifies the character set of the document data.").required(true).defaultValue("UTF-8").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    public static final PropertyDescriptor INFLUX_DB_URL = new PropertyDescriptor.Builder().name("influxdb-url").displayName("InfluxDB connection URL").description("InfluxDB URL to connect to. Eg: http://influxdb:8086").defaultValue("http://localhost:8086").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor INFLUX_DB_CONNECTION_TIMEOUT = new PropertyDescriptor.Builder().name("InfluxDB Max Connection Time Out (seconds)").description("The maximum time for establishing connection to the InfluxDB").defaultValue("0 seconds").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).sensitive(false).build();
    public static final PropertyDescriptor DB_NAME = new PropertyDescriptor.Builder().name("influxdb-dbname").displayName("Database Name").description("InfluxDB database to connect to").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("influxdb-username").displayName("Username").required(false).description("Username for accessing InfluxDB").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("influxdb-password").displayName("Password").required(false).description("Password for user").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor MAX_RECORDS_SIZE = new PropertyDescriptor.Builder().name("influxdb-max-records-size").displayName("Max size of records").description("Maximum size of records allowed to be posted in one batch").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("1 MB").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).build();
    public static final String INFLUX_DB_ERROR_MESSAGE = "influxdb.error.message";
    protected AtomicReference<InfluxDB> influxDB = new AtomicReference();
    protected long maxRecordsSize;

    protected synchronized InfluxDB getInfluxDB(ProcessContext context) {
        if (this.influxDB.get() == null) {
            String username = context.getProperty(USERNAME).evaluateAttributeExpressions().getValue();
            String password = context.getProperty(PASSWORD).evaluateAttributeExpressions().getValue();
            long connectionTimeout = context.getProperty(INFLUX_DB_CONNECTION_TIMEOUT).asTimePeriod(TimeUnit.SECONDS);
            String influxDbUrl = context.getProperty(INFLUX_DB_URL).evaluateAttributeExpressions().getValue();
            try {
                this.influxDB.set(this.makeConnection(username, password, influxDbUrl, connectionTimeout));
            }
            catch (Exception e) {
                this.getLogger().error("Error while getting connection {}", new Object[]{e.getLocalizedMessage()}, (Throwable)e);
                throw new RuntimeException("Error while getting connection " + e.getLocalizedMessage(), e);
            }
            this.getLogger().info("InfluxDB connection created for host {}", new Object[]{influxDbUrl});
        }
        return this.influxDB.get();
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
    }

    protected InfluxDB makeConnection(String username, String password, String influxDbUrl, long connectionTimeout) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(connectionTimeout, TimeUnit.SECONDS);
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            return InfluxDBFactory.connect((String)influxDbUrl, (OkHttpClient.Builder)builder);
        }
        return InfluxDBFactory.connect((String)influxDbUrl, (String)username, (String)password, (OkHttpClient.Builder)builder);
    }

    @OnStopped
    public void close() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().info("Closing connection");
        }
        if (this.influxDB.get() != null) {
            this.influxDB.get().close();
            this.influxDB.set(null);
        }
    }
}

