/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.JmsTemplate;

abstract class AbstractJMSProcessor<T extends JMSWorker>
extends AbstractProcessor {
    static final String QUEUE = "QUEUE";
    static final String TOPIC = "TOPIC";
    static final PropertyDescriptor USER = new PropertyDescriptor.Builder().name("User Name").description("User Name used for authentication and authorization.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password used for authentication and authorization.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination Name").description("The name of the JMS Destination. Usually provided by the administrator (e.g., 'topic://myTopic' or 'myTopic').").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    static final PropertyDescriptor DESTINATION_TYPE = new PropertyDescriptor.Builder().name("Destination Type").description("The type of the JMS Destination. Could be one of 'QUEUE' or 'TOPIC'. Usually provided by the administrator. Defaults to 'TOPIC").required(true).allowableValues(new String[]{"QUEUE", "TOPIC"}).defaultValue("QUEUE").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor SESSION_CACHE_SIZE = new PropertyDescriptor.Builder().name("Session Cache size").description("The maximum limit for the number of cached Sessions.").required(true).defaultValue("1").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor CF_SERVICE = new PropertyDescriptor.Builder().name("Connection Factory Service").description("The Controller Service that is used to obtain ConnectionFactory").required(true).identifiesControllerService(JMSConnectionFactoryProviderDefinition.class).build();
    static final List<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
    protected volatile T targetResource;
    private volatile CachingConnectionFactory cachingConnectionFactory;

    AbstractJMSProcessor() {
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        AbstractJMSProcessor abstractJMSProcessor = this;
        synchronized (abstractJMSProcessor) {
            this.buildTargetResource(context);
        }
        this.rendezvousWithJms(context, session);
    }

    @OnStopped
    public void close() {
        if (this.cachingConnectionFactory != null) {
            this.cachingConnectionFactory.destroy();
        }
        this.targetResource = null;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " - " + this.targetResource;
    }

    protected abstract void rendezvousWithJms(ProcessContext var1, ProcessSession var2) throws ProcessException;

    protected abstract T finishBuildingTargetResource(JmsTemplate var1, ProcessContext var2);

    private void buildTargetResource(ProcessContext context) {
        if (this.targetResource == null) {
            JMSConnectionFactoryProviderDefinition cfProvider = (JMSConnectionFactoryProviderDefinition)context.getProperty(CF_SERVICE).asControllerService(JMSConnectionFactoryProviderDefinition.class);
            ConnectionFactory connectionFactory = cfProvider.getConnectionFactory();
            UserCredentialsConnectionFactoryAdapter cfCredentialsAdapter = new UserCredentialsConnectionFactoryAdapter();
            cfCredentialsAdapter.setTargetConnectionFactory(connectionFactory);
            cfCredentialsAdapter.setUsername(context.getProperty(USER).getValue());
            cfCredentialsAdapter.setPassword(context.getProperty(PASSWORD).getValue());
            this.cachingConnectionFactory = new CachingConnectionFactory((ConnectionFactory)cfCredentialsAdapter);
            this.cachingConnectionFactory.setSessionCacheSize(Integer.parseInt(context.getProperty(SESSION_CACHE_SIZE).getValue()));
            JmsTemplate jmsTemplate = new JmsTemplate();
            jmsTemplate.setConnectionFactory((ConnectionFactory)this.cachingConnectionFactory);
            jmsTemplate.setPubSubDomain(TOPIC.equals(context.getProperty(DESTINATION_TYPE).getValue()));
            jmsTemplate.setReceiveTimeout(1000L);
            this.targetResource = this.finishBuildingTargetResource(jmsTemplate, context);
        }
    }

    static {
        propertyDescriptors.add(CF_SERVICE);
        propertyDescriptors.add(DESTINATION);
        propertyDescriptors.add(DESTINATION_TYPE);
        propertyDescriptors.add(USER);
        propertyDescriptors.add(PASSWORD);
        propertyDescriptors.add(SESSION_CACHE_SIZE);
    }
}

