/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jms.ConnectionFactory;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.jms.cf.Utils;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"jms", "messaging", "integration", "queue", "topic", "publish", "subscribe"})
@CapabilityDescription(value="Provides a generic service to create vendor specific javax.jms.ConnectionFactory implementations. ConnectionFactory can be served once this service is configured successfully")
@DynamicProperty(name="The name of a Connection Factory configuration property.", value="The value of a given Connection Factory configuration property.", description="The properties that are set following Java Beans convention where a property name is derived from the 'set*' method of the vendor specific ConnectionFactory's implementation. For example, 'com.ibm.mq.jms.MQConnectionFactory.setChannel(String)' would imply 'channel' property and 'com.ibm.mq.jms.MQConnectionFactory.setTransportType(int)' would imply 'transportType' property.", expressionLanguageScope=ExpressionLanguageScope.VARIABLE_REGISTRY)
@SeeAlso(classNames={"org.apache.nifi.jms.processors.ConsumeJMS", "org.apache.nifi.jms.processors.PublishJMS"})
public class JMSConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition {
    private final Logger logger = LoggerFactory.getLogger(JMSConnectionFactoryProvider.class);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS;
    private volatile boolean configured;
    private volatile ConnectionFactory connectionFactory;
    private static final String BROKER = "broker";
    private static final String CF_IMPL = "cf";
    private static final String CF_LIB = "cflib";
    public static final PropertyDescriptor CONNECTION_FACTORY_IMPL;
    public static final PropertyDescriptor CLIENT_LIB_DIR_PATH;
    public static final PropertyDescriptor BROKER_URI;
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value for '" + propertyDescriptorName + "' property to be set on the provided ConnectionFactory implementation.").name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    public void resetConnectionFactory(ConnectionFactory cachedFactory) {
        if (cachedFactory == this.connectionFactory) {
            this.getLogger().debug("Resetting connection factory");
            this.connectionFactory = null;
        }
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.configured) {
            return this.connectionFactory;
        }
        throw new IllegalStateException("ConnectionFactory can not be obtained unless this ControllerService is configured. See onConfigure(ConfigurationContext) method.");
    }

    @OnEnabled
    public void enable(ConfigurationContext context) {
        try {
            if (!this.configured) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Configuring " + ((Object)((Object)this)).getClass().getSimpleName() + " for '" + context.getProperty(CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue() + "' to be connected to '" + context.getProperty(BROKER_URI).evaluateAttributeExpressions().getValue() + "'");
                }
                this.createConnectionFactoryInstance(context);
                this.setConnectionFactoryProperties(context);
            }
            this.configured = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to configure " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
            this.configured = false;
            throw new IllegalStateException(e);
        }
    }

    @OnDisabled
    public void disable() {
        this.connectionFactory = null;
        this.configured = false;
    }

    void setConnectionFactoryProperties(ConfigurationContext context) {
        SSLContextService sc;
        if (context.getProperty(BROKER_URI).isSet()) {
            String brokerValue = context.getProperty(BROKER_URI).evaluateAttributeExpressions().getValue();
            String connectionFactoryValue = context.getProperty(CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
            if (connectionFactoryValue.startsWith("org.apache.activemq")) {
                this.setProperty("brokerURL", brokerValue);
            } else if (connectionFactoryValue.startsWith("com.tibco.tibjms")) {
                this.setProperty("serverUrl", brokerValue);
            } else {
                String[] brokerList = brokerValue.split(",");
                if (connectionFactoryValue.startsWith("com.ibm.mq.jms")) {
                    ArrayList<String> ibmConList = new ArrayList<String>();
                    for (String broker : brokerList) {
                        String[] hostPort = broker.split(":");
                        if (hostPort.length == 2) {
                            ibmConList.add(hostPort[0] + "(" + hostPort[1] + ")");
                            continue;
                        }
                        ibmConList.add(broker);
                    }
                    this.setProperty("connectionNameList", String.join((CharSequence)",", ibmConList));
                } else {
                    String[] hostPort = brokerList[0].split(":");
                    if (hostPort.length == 2) {
                        this.setProperty("hostName", hostPort[0]);
                        this.setProperty("port", hostPort[1]);
                    }
                }
            }
        }
        if ((sc = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) != null) {
            SSLContext ssl = sc.createSSLContext(SSLContextService.ClientAuth.NONE);
            this.setProperty("sSLSocketFactory", ssl.getSocketFactory());
        }
        List dynamicProperties = context.getProperties().entrySet().stream().filter(entry -> ((PropertyDescriptor)entry.getKey()).isDynamic()).collect(Collectors.toList());
        for (Map.Entry entry2 : dynamicProperties) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry2.getKey();
            String propertyName = descriptor.getName();
            String propertyValue = context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
            this.setProperty(propertyName, propertyValue);
        }
    }

    void setProperty(String propertyName, Object propertyValue) {
        String methodName = this.toMethodName(propertyName);
        Method[] methods = Utils.findMethods(methodName, this.connectionFactory.getClass());
        if (methods != null && methods.length > 0) {
            try {
                for (Method method : methods) {
                    Class<?> returnType = method.getParameterTypes()[0];
                    if (String.class.isAssignableFrom(returnType)) {
                        method.invoke((Object)this.connectionFactory, propertyValue);
                        return;
                    }
                    if (Integer.TYPE.isAssignableFrom(returnType)) {
                        method.invoke((Object)this.connectionFactory, Integer.parseInt((String)propertyValue));
                        return;
                    }
                    if (Long.TYPE.isAssignableFrom(returnType)) {
                        method.invoke((Object)this.connectionFactory, Long.parseLong((String)propertyValue));
                        return;
                    }
                    if (!Boolean.TYPE.isAssignableFrom(returnType)) continue;
                    method.invoke((Object)this.connectionFactory, Boolean.parseBoolean((String)propertyValue));
                    return;
                }
                methods[0].invoke((Object)this.connectionFactory, propertyValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set property " + propertyName, e);
            }
        } else if (propertyName.equals("hostName")) {
            this.setProperty("host", propertyValue);
        }
    }

    private void createConnectionFactoryInstance(ConfigurationContext context) {
        String connectionFactoryImplName = context.getProperty(CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
        this.connectionFactory = (ConnectionFactory)Utils.newDefaultInstance(connectionFactoryImplName);
    }

    private String toMethodName(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        return "set" + new String(c);
    }

    static {
        CONNECTION_FACTORY_IMPL = new PropertyDescriptor.Builder().name(CF_IMPL).displayName("MQ ConnectionFactory Implementation").description("A fully qualified name of the JMS ConnectionFactory implementation class (i.e., org.apache.activemq.ActiveMQConnectionFactory)").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        CLIENT_LIB_DIR_PATH = new PropertyDescriptor.Builder().name(CF_LIB).displayName("MQ Client Libraries path (i.e. /usr/jms/lib)").description("Path to the directory with additional resources (i.e., JARs, configuration files etc.) to be added to the classpath. Such resources typically represent target MQ client libraries for the ConnectionFactory implementation. Required if target is not ActiveMQ.").addValidator(StandardValidators.createListValidator((boolean)true, (boolean)true, (Validator)StandardValidators.createURLorFileValidator())).required(false).dynamicallyModifiesClasspath(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        BROKER_URI = new PropertyDescriptor.Builder().name(BROKER).displayName("Broker URI").description("URI pointing to the network location of the JMS Message broker. Example for ActiveMQ: 'tcp://myhost:61616'. Examples for IBM MQ: 'myhost(1414)' and 'myhost01(1414),myhost02(1414)'").addValidator((Validator)new NonEmptyBrokerURIValidator()).required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
        SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextService.class).build();
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FACTORY_IMPL, CLIENT_LIB_DIR_PATH, BROKER_URI, SSL_CONTEXT_SERVICE));
    }

    static class NonEmptyBrokerURIValidator
    implements Validator {
        NonEmptyBrokerURIValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
            }
            return StandardValidators.NON_EMPTY_VALIDATOR.validate(subject, input, context);
        }
    }
}

