/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.jms.cf.IJMSConnectionFactoryProvider;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProperties;
import org.apache.nifi.jms.cf.Utils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.security.util.ClientAuth;
import org.apache.nifi.ssl.SSLContextService;

public class JMSConnectionFactoryHandler
implements IJMSConnectionFactoryProvider {
    private final PropertyContext context;
    private final Set<PropertyDescriptor> propertyDescriptors;
    private final ComponentLog logger;
    private volatile ConnectionFactory connectionFactory;

    public JMSConnectionFactoryHandler(ConfigurationContext context, ComponentLog logger) {
        this.context = context;
        this.propertyDescriptors = context.getProperties().keySet();
        this.logger = logger;
    }

    public JMSConnectionFactoryHandler(ProcessContext context, ComponentLog logger) {
        this.context = context;
        this.propertyDescriptors = context.getProperties().keySet();
        this.logger = logger;
    }

    public synchronized ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.initConnectionFactory();
        } else {
            this.logger.debug("Connection Factory has already been initialized. Will return cached instance.");
        }
        return this.connectionFactory;
    }

    public synchronized void resetConnectionFactory(ConnectionFactory cachedFactory) {
        if (cachedFactory == this.connectionFactory) {
            this.logger.debug("Resetting connection factory");
            this.connectionFactory = null;
        }
    }

    private void initConnectionFactory() {
        try {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Configuring " + this.getClass().getSimpleName() + " for '" + this.context.getProperty(JMSConnectionFactoryProperties.JMS_CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue() + "' to be connected to '" + this.context.getProperty(JMSConnectionFactoryProperties.JMS_BROKER_URI).evaluateAttributeExpressions().getValue() + "'");
            }
            this.createConnectionFactoryInstance();
            this.setConnectionFactoryProperties();
        }
        catch (Exception e) {
            this.connectionFactory = null;
            this.logger.error("Failed to configure " + this.getClass().getSimpleName(), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private void createConnectionFactoryInstance() {
        String connectionFactoryImplName = this.context.getProperty(JMSConnectionFactoryProperties.JMS_CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
        this.connectionFactory = (ConnectionFactory)Utils.newDefaultInstance(connectionFactoryImplName);
    }

    void setConnectionFactoryProperties() {
        SSLContextService sc;
        if (this.context.getProperty(JMSConnectionFactoryProperties.JMS_BROKER_URI).isSet()) {
            String brokerValue = this.context.getProperty(JMSConnectionFactoryProperties.JMS_BROKER_URI).evaluateAttributeExpressions().getValue();
            String connectionFactoryValue = this.context.getProperty(JMSConnectionFactoryProperties.JMS_CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
            if (connectionFactoryValue.startsWith("org.apache.activemq")) {
                this.setProperty("brokerURL", brokerValue);
            } else if (connectionFactoryValue.startsWith("com.tibco.tibjms")) {
                this.setProperty("serverUrl", brokerValue);
            } else {
                String[] brokerList = brokerValue.split(",");
                if (connectionFactoryValue.startsWith("com.ibm.mq.jms")) {
                    ArrayList<String> ibmConList = new ArrayList<String>();
                    for (String broker : brokerList) {
                        String[] hostPort = broker.split(":");
                        if (hostPort.length == 2) {
                            ibmConList.add(hostPort[0] + "(" + hostPort[1] + ")");
                            continue;
                        }
                        ibmConList.add(broker);
                    }
                    this.setProperty("connectionNameList", String.join((CharSequence)",", ibmConList));
                } else {
                    String[] hostPort = brokerList[0].split(":");
                    if (hostPort.length == 2) {
                        this.setProperty("hostName", hostPort[0]);
                        this.setProperty("port", hostPort[1]);
                    }
                }
            }
        }
        if ((sc = (SSLContextService)this.context.getProperty(JMSConnectionFactoryProperties.JMS_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) != null) {
            SSLContext ssl = sc.createSSLContext(ClientAuth.NONE);
            this.setProperty("sSLSocketFactory", ssl.getSocketFactory());
        }
        this.propertyDescriptors.stream().filter(PropertyDescriptor::isDynamic).forEach(descriptor -> {
            String propertyName = descriptor.getName();
            String propertyValue = this.context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
            this.setProperty(propertyName, propertyValue);
        });
    }

    void setProperty(String propertyName, Object propertyValue) {
        String methodName = this.toMethodName(propertyName);
        Method[] methods = Utils.findMethods(methodName, this.connectionFactory.getClass());
        if (methods != null && methods.length > 0) {
            try {
                for (Method method : methods) {
                    Class<?> returnType = method.getParameterTypes()[0];
                    if (String.class.isAssignableFrom(returnType)) {
                        method.invoke((Object)this.connectionFactory, propertyValue);
                        return;
                    }
                    if (Integer.TYPE.isAssignableFrom(returnType)) {
                        method.invoke((Object)this.connectionFactory, Integer.parseInt((String)propertyValue));
                        return;
                    }
                    if (Long.TYPE.isAssignableFrom(returnType)) {
                        method.invoke((Object)this.connectionFactory, Long.parseLong((String)propertyValue));
                        return;
                    }
                    if (!Boolean.TYPE.isAssignableFrom(returnType)) continue;
                    method.invoke((Object)this.connectionFactory, Boolean.parseBoolean((String)propertyValue));
                    return;
                }
                methods[0].invoke((Object)this.connectionFactory, propertyValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set property " + propertyName, e);
            }
        } else if (propertyName.equals("hostName")) {
            this.setProperty("host", propertyValue);
        }
    }

    private String toMethodName(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        return "set" + new String(c);
    }
}

