/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.jms.cf.Utils;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.ssl.SSLContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tags(value={"jms", "messaging", "integration", "queue", "topic", "publish", "subscribe"})
@CapabilityDescription(value="Provides a generic service to create vendor specific javax.jms.ConnectionFactory implementations. ConnectionFactory can be served once this service is configured successfully")
@DynamicProperty(name="The name of a Connection Factory configuration property.", value="The value of a given Connection Factory configuration property.", description="The properties that are set following Java Beans convention where a property name is derived from the 'set*' method of the vendor specific ConnectionFactory's implementation. For example, 'com.ibm.mq.jms.MQConnectionFactory.setChannel(String)' would imply 'channel' property and 'com.ibm.mq.jms.MQConnectionFactory.setTransportType(int)' would imply 'transportType' property.")
@SeeAlso(classNames={"org.apache.nifi.jms.processors.ConsumeJMS", "org.apache.nifi.jms.processors.PublishJMS"})
public class JMSConnectionFactoryProvider
extends AbstractControllerService
implements JMSConnectionFactoryProviderDefinition {
    private final Logger logger = LoggerFactory.getLogger(JMSConnectionFactoryProvider.class);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS;
    private volatile boolean configured;
    private volatile ConnectionFactory connectionFactory;
    static final String BROKER = "broker";
    static final String CF_IMPL = "cf";
    static final String CF_LIB = "cflib";
    public static final PropertyDescriptor CONNECTION_FACTORY_IMPL;
    public static final PropertyDescriptor CLIENT_LIB_DIR_PATH;
    public static final PropertyDescriptor BROKER_URI;
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value for '" + propertyDescriptorName + "' property to be set on the provided ConnectionFactory implementation.").name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).build();
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.configured) {
            return this.connectionFactory;
        }
        throw new IllegalStateException("ConnectionFactory can not be obtained unless this ControllerService is configured. See onConfigure(ConfigurationContext) method.");
    }

    @OnEnabled
    public void enable(ConfigurationContext context) throws InitializationException {
        try {
            if (!this.configured) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Configuring " + ((Object)((Object)this)).getClass().getSimpleName() + " for '" + context.getProperty(CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue() + "' to be connected to '" + BROKER_URI + "'");
                }
                Utils.addResourcesToClasspath(context.getProperty(CLIENT_LIB_DIR_PATH).evaluateAttributeExpressions().getValue());
                this.createConnectionFactoryInstance(context);
                this.setConnectionFactoryProperties(context);
            }
            this.configured = true;
        }
        catch (Exception e) {
            this.logger.error("Failed to configure " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)e);
            this.configured = false;
            throw new IllegalStateException(e);
        }
    }

    @OnDisabled
    public void disable() {
        this.connectionFactory = null;
        this.configured = false;
    }

    private void setConnectionFactoryProperties(ConfigurationContext context) {
        for (Map.Entry entry : context.getProperties().entrySet()) {
            SSLContextService sc;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            String propertyName = descriptor.getName();
            if (descriptor.isDynamic()) {
                this.setProperty(propertyName, entry.getValue());
                continue;
            }
            if (!propertyName.equals(BROKER)) continue;
            String brokerValue = context.getProperty(descriptor).evaluateAttributeExpressions().getValue();
            if (context.getProperty(CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue().startsWith("org.apache.activemq")) {
                this.setProperty("brokerURL", brokerValue);
            } else {
                String[] hostPort = brokerValue.split(":");
                if (hostPort.length == 2) {
                    this.setProperty("hostName", hostPort[0]);
                    this.setProperty("port", hostPort[1]);
                } else if (hostPort.length != 2) {
                    this.setProperty("serverUrl", brokerValue);
                } else {
                    throw new IllegalArgumentException("Failed to parse broker url: " + brokerValue);
                }
            }
            if ((sc = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class)) == null) continue;
            SSLContext ssl = sc.createSSLContext(SSLContextService.ClientAuth.NONE);
            this.setProperty("sSLSocketFactory", ssl.getSocketFactory());
        }
    }

    private void setProperty(String propertyName, Object propertyValue) {
        String methodName = this.toMethodName(propertyName);
        Method method = Utils.findMethod(methodName, this.connectionFactory.getClass());
        if (method != null) {
            try {
                Class<?> returnType = method.getParameterTypes()[0];
                if (String.class.isAssignableFrom(returnType)) {
                    method.invoke((Object)this.connectionFactory, propertyValue);
                }
                if (Integer.TYPE.isAssignableFrom(returnType)) {
                    method.invoke((Object)this.connectionFactory, Integer.parseInt((String)propertyValue));
                }
                if (Long.TYPE.isAssignableFrom(returnType)) {
                    method.invoke((Object)this.connectionFactory, Long.parseLong((String)propertyValue));
                }
                if (Boolean.TYPE.isAssignableFrom(returnType)) {
                    method.invoke((Object)this.connectionFactory, Boolean.parseBoolean((String)propertyValue));
                }
                method.invoke((Object)this.connectionFactory, propertyValue);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to set property " + propertyName, e);
            }
        } else if (propertyName.equals("hostName")) {
            this.setProperty("host", propertyValue);
        }
    }

    private void createConnectionFactoryInstance(ConfigurationContext context) {
        String connectionFactoryImplName = context.getProperty(CONNECTION_FACTORY_IMPL).evaluateAttributeExpressions().getValue();
        this.connectionFactory = (ConnectionFactory)Utils.newDefaultInstance(connectionFactoryImplName);
    }

    private String toMethodName(String propertyName) {
        char[] c = propertyName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        return "set" + new String(c);
    }

    static {
        CONNECTION_FACTORY_IMPL = new PropertyDescriptor.Builder().name(CF_IMPL).displayName("MQ ConnectionFactory Implementation").description("A fully qualified name of the JMS ConnectionFactory implementation class (i.e., org.apache.activemq.ActiveMQConnectionFactory)").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(true).expressionLanguageSupported(true).build();
        CLIENT_LIB_DIR_PATH = new PropertyDescriptor.Builder().name(CF_LIB).displayName("MQ Client Libraries path (i.e., /usr/jms/lib)").description("Path to the directory with additional resources (i.e., JARs, configuration files etc.) to be added to the classpath. Such resources typically represent target MQ client libraries for the ConnectionFactory implementation.").addValidator((Validator)new ClientLibValidator()).required(true).expressionLanguageSupported(true).build();
        BROKER_URI = new PropertyDescriptor.Builder().name(BROKER).displayName("Broker URI").description("URI pointing to the network location of the JMS Message broker. For example, 'tcp://myhost:61616' for ActiveMQ or 'myhost:1414' for IBM MQ").addValidator((Validator)new NonEmptyBrokerURIValidator()).required(true).expressionLanguageSupported(true).build();
        SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextService.class).build();
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(Arrays.asList(CONNECTION_FACTORY_IMPL, CLIENT_LIB_DIR_PATH, BROKER_URI, SSL_CONTEXT_SERVICE));
    }

    static class ClientLibValidator
    implements Validator {
        ClientLibValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String libDirPath = context.getProperty(CLIENT_LIB_DIR_PATH).evaluateAttributeExpressions().getValue();
            StringBuilder invalidationMessageBuilder = new StringBuilder();
            if (libDirPath != null) {
                File file = new File(libDirPath);
                if (!file.isDirectory()) {
                    invalidationMessageBuilder.append("MQ Client library directory path must point to a directory. Was '").append(file.getAbsolutePath()).append("'.");
                }
            } else {
                invalidationMessageBuilder.append("'MQ Client Libraries path' must be provided. \n");
            }
            String invalidationMessage = invalidationMessageBuilder.toString();
            ValidationResult vResult = invalidationMessage.length() == 0 ? new ValidationResult.Builder().subject(subject).input(input).explanation("Client lib path is valid and points to a directory").valid(true).build() : new ValidationResult.Builder().subject(subject).input(input).explanation("Client lib path is invalid. " + invalidationMessage).valid(false).build();
            return vResult;
        }
    }

    static class NonEmptyBrokerURIValidator
    implements Validator {
        NonEmptyBrokerURIValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String value = input;
            if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
                value = context.getProperty(BROKER_URI).evaluateAttributeExpressions().getValue();
            }
            return StandardValidators.NON_EMPTY_VALIDATOR.validate(subject, value, context);
        }
    }
}

