/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.jms.processors.MessageBodyToBytesConverter;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.support.JmsUtils;

final class JMSConsumer
extends JMSWorker {
    JMSConsumer(JmsTemplate jmsTemplate, ComponentLog processLog) {
        super(jmsTemplate, processLog);
        if (this.processLog.isInfoEnabled()) {
            this.processLog.info("Created Message Consumer for '" + jmsTemplate.toString() + "'.");
        }
    }

    public void consume(final String destinationName, final boolean durable, final boolean shared, final String subscriberName, final ConsumerCallback consumerCallback) {
        this.jmsTemplate.execute((SessionCallback)new SessionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doInJms(Session session) throws JMSException {
                MessageConsumer msgConsumer;
                session.recover();
                boolean isPubSub = JMSConsumer.this.jmsTemplate.isPubSubDomain();
                Destination destination = JMSConsumer.this.jmsTemplate.getDestinationResolver().resolveDestinationName(session, destinationName, isPubSub);
                if (isPubSub) {
                    if (shared) {
                        try {
                            if (durable) {
                                msgConsumer = session.createSharedDurableConsumer((Topic)destination, subscriberName);
                            }
                            msgConsumer = session.createSharedConsumer((Topic)destination, subscriberName);
                        }
                        catch (AbstractMethodError e) {
                            throw new ProcessException("Failed to create a shared consumer. Make sure the target broker is JMS 2.0 compliant.", (Throwable)e);
                        }
                    } else {
                        msgConsumer = durable ? session.createDurableConsumer((Topic)destination, subscriberName, null, JMSConsumer.this.jmsTemplate.isPubSubDomain()) : session.createConsumer((Destination)((Topic)destination), null, JMSConsumer.this.jmsTemplate.isPubSubDomain());
                    }
                } else {
                    msgConsumer = session.createConsumer(destination, null, JMSConsumer.this.jmsTemplate.isPubSubDomain());
                }
                Message message = msgConsumer.receive(JMSConsumer.this.jmsTemplate.getReceiveTimeout());
                JMSResponse response = null;
                try {
                    if (message != null) {
                        byte[] messageBody = null;
                        if (message instanceof TextMessage) {
                            messageBody = MessageBodyToBytesConverter.toBytes((TextMessage)message);
                        } else if (message instanceof BytesMessage) {
                            messageBody = MessageBodyToBytesConverter.toBytes((BytesMessage)message);
                        } else {
                            throw new IllegalStateException("Message type other then TextMessage and BytesMessage are not supported at the moment");
                        }
                        Map messageHeaders = JMSConsumer.this.extractMessageHeaders(message);
                        Map messageProperties = JMSConsumer.this.extractMessageProperties(message);
                        response = new JMSResponse(messageBody, messageHeaders, messageProperties);
                    }
                    consumerCallback.accept(response);
                    if (message != null && session.getAcknowledgeMode() == 2) {
                        message.acknowledge();
                    }
                }
                finally {
                    JmsUtils.closeMessageConsumer((MessageConsumer)msgConsumer);
                }
                return null;
            }
        }, true);
    }

    private Map<String, String> extractMessageProperties(Message message) {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            Enumeration propertyNames = message.getPropertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                properties.put(propertyName, String.valueOf(message.getObjectProperty(propertyName)));
            }
        }
        catch (JMSException e) {
            this.processLog.warn("Failed to extract message properties", (Throwable)e);
        }
        return properties;
    }

    private Map<String, Object> extractMessageHeaders(Message message) {
        HashMap<String, Object> messageHeaders = new HashMap<String, Object>();
        try {
            String destinationName;
            messageHeaders.put("jms_deliveryMode", String.valueOf(message.getJMSDeliveryMode()));
            messageHeaders.put("jms_expiration", String.valueOf(message.getJMSExpiration()));
            messageHeaders.put("jms_priority", String.valueOf(message.getJMSPriority()));
            messageHeaders.put("jms_redelivered", String.valueOf(message.getJMSRedelivered()));
            messageHeaders.put("jms_timestamp", String.valueOf(message.getJMSTimestamp()));
            messageHeaders.put("jms_correlationId", message.getJMSCorrelationID());
            messageHeaders.put("jms_messageId", message.getJMSMessageID());
            messageHeaders.put("jms_type", message.getJMSType());
            String replyToDestinationName = this.retrieveDestinationName(message.getJMSReplyTo(), "jms_replyTo");
            if (replyToDestinationName != null) {
                messageHeaders.put("jms_replyTo", replyToDestinationName);
            }
            if ((destinationName = this.retrieveDestinationName(message.getJMSDestination(), "jms_destination")) != null) {
                messageHeaders.put("jms_destination", destinationName);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to extract JMS Headers", e);
        }
        return messageHeaders;
    }

    private String retrieveDestinationName(Destination destination, String headerName) {
        String destinationName = null;
        if (destination != null) {
            try {
                destinationName = destination instanceof Queue ? ((Queue)destination).getQueueName() : ((Topic)destination).getTopicName();
            }
            catch (JMSException e) {
                this.processLog.warn("Failed to retrieve Destination name for '" + headerName + "' header", (Throwable)e);
            }
        }
        return destinationName;
    }

    static interface ConsumerCallback {
        public void accept(JMSResponse var1);
    }

    static class JMSResponse {
        private final byte[] messageBody;
        private final Map<String, Object> messageHeaders;
        private final Map<String, String> messageProperties;

        JMSResponse(byte[] messageBody, Map<String, Object> messageHeaders, Map<String, String> messageProperties) {
            this.messageBody = messageBody;
            this.messageHeaders = Collections.unmodifiableMap(messageHeaders);
            this.messageProperties = Collections.unmodifiableMap(messageProperties);
        }

        public byte[] getMessageBody() {
            return this.messageBody;
        }

        public Map<String, Object> getMessageHeaders() {
            return this.messageHeaders;
        }

        public Map<String, String> getMessageProperties() {
            return this.messageProperties;
        }
    }
}

