/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    static <T> T newDefaultInstance(String className) {
        try {
            Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load and/or instantiate class '" + className + "'", e);
        }
    }

    public static Method findMethod(String name, Class<?> targetClass) {
        for (Class<?> searchType = targetClass; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName())) continue;
                return method;
            }
        }
        return null;
    }

    public static Method[] findMethods(String name, Class<?> targetClass) {
        ArrayList<Method> fittingMethods = new ArrayList<Method>();
        for (Class<?> searchType = targetClass; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName())) continue;
                fittingMethods.add(method);
            }
        }
        if (fittingMethods.isEmpty()) {
            return null;
        }
        Collections.sort(fittingMethods, Comparator.comparing(Method::getParameterCount));
        return fittingMethods.toArray(new Method[fittingMethods.size()]);
    }

    static void addResourcesToClasspath(String path) {
        URL[] urls;
        if (logger.isDebugEnabled()) {
            logger.debug("Adding additional resources from '" + path + "' to the classpath.");
        }
        if (path == null) {
            throw new IllegalArgumentException("'path' must not be null");
        }
        File libraryDir = new File(path);
        if (libraryDir.exists() && libraryDir.isDirectory()) {
            String[] cpResourceNames = libraryDir.list();
            urls = new URL[cpResourceNames.length];
            try {
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = new File(libraryDir, cpResourceNames[i]).toURI().toURL();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Identifying additional resource to the classpath: " + urls[i]);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to parse user libraries from '" + libraryDir.getAbsolutePath() + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Path '" + libraryDir.getAbsolutePath() + "' is not valid because it doesn't exist or does not point to a directory.");
        }
        URLClassLoader cl = new URLClassLoader(urls, Utils.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(cl);
    }
}

