/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jms.cf.JMSConnectionFactoryProviderDefinition;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.connection.UserCredentialsConnectionFactoryAdapter;
import org.springframework.jms.core.JmsTemplate;

abstract class AbstractJMSProcessor<T extends JMSWorker>
extends AbstractProcessor {
    static final String QUEUE = "QUEUE";
    static final String TOPIC = "TOPIC";
    static final String TEXT_MESSAGE = "text";
    static final String BYTES_MESSAGE = "bytes";
    static final PropertyDescriptor USER = new PropertyDescriptor.Builder().name("User Name").description("User Name used for authentication and authorization.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password used for authentication and authorization.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    static final PropertyDescriptor DESTINATION = new PropertyDescriptor.Builder().name("Destination Name").description("The name of the JMS Destination. Usually provided by the administrator (e.g., 'topic://myTopic' or 'myTopic').").required(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor DESTINATION_TYPE = new PropertyDescriptor.Builder().name("Destination Type").description("The type of the JMS Destination. Could be one of 'QUEUE' or 'TOPIC'. Usually provided by the administrator. Defaults to 'QUEUE'").required(true).allowableValues(new String[]{"QUEUE", "TOPIC"}).defaultValue("QUEUE").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static final PropertyDescriptor CLIENT_ID = new PropertyDescriptor.Builder().name("Connection Client ID").description("The client id to be set on the connection, if set. For durable non shared consumer this is mandatory, for all others it is optional, typically with shared consumers it is undesirable to be set. Please see JMS spec for further details").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor SESSION_CACHE_SIZE = new PropertyDescriptor.Builder().name("Session Cache size").description("This property is deprecated and no longer has any effect on the Processor. It will be removed in a later version.").required(false).defaultValue("1").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor MESSAGE_BODY = new PropertyDescriptor.Builder().name("message-body-type").displayName("Message Body Type").description("The type of JMS message body to construct.").required(true).defaultValue("bytes").allowableValues(new String[]{"bytes", "text"}).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("character-set").displayName("Character Set").description("The name of the character set to use to construct or interpret TextMessages").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue(Charset.defaultCharset().name()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor CF_SERVICE = new PropertyDescriptor.Builder().name("Connection Factory Service").description("The Controller Service that is used to obtain ConnectionFactory").required(true).identifiesControllerService(JMSConnectionFactoryProviderDefinition.class).build();
    static final List<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
    private volatile BlockingQueue<T> workerPool;
    private final AtomicInteger clientIdCounter = new AtomicInteger(1);

    AbstractJMSProcessor() {
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        JMSWorker worker = (JMSWorker)this.workerPool.poll();
        if (worker == null) {
            worker = this.buildTargetResource(context);
        }
        this.rendezvousWithJms(context, session, worker);
        this.workerPool.offer(worker);
    }

    @OnScheduled
    public void setupWorkerPool(ProcessContext context) {
        this.workerPool = new LinkedBlockingQueue<T>(context.getMaxConcurrentTasks());
    }

    @OnStopped
    public void close() {
        JMSWorker worker;
        while ((worker = (JMSWorker)this.workerPool.poll()) != null) {
            worker.shutdown();
        }
    }

    protected abstract void rendezvousWithJms(ProcessContext var1, ProcessSession var2, T var3) throws ProcessException;

    protected abstract T finishBuildingJmsWorker(CachingConnectionFactory var1, JmsTemplate var2, ProcessContext var3);

    private T buildTargetResource(ProcessContext context) {
        JMSConnectionFactoryProviderDefinition cfProvider = (JMSConnectionFactoryProviderDefinition)context.getProperty(CF_SERVICE).asControllerService(JMSConnectionFactoryProviderDefinition.class);
        ConnectionFactory connectionFactory = cfProvider.getConnectionFactory();
        UserCredentialsConnectionFactoryAdapter cfCredentialsAdapter = new UserCredentialsConnectionFactoryAdapter();
        cfCredentialsAdapter.setTargetConnectionFactory(connectionFactory);
        cfCredentialsAdapter.setUsername(context.getProperty(USER).getValue());
        cfCredentialsAdapter.setPassword(context.getProperty(PASSWORD).getValue());
        CachingConnectionFactory cachingFactory = new CachingConnectionFactory((ConnectionFactory)cfCredentialsAdapter);
        String clientId = context.getProperty(CLIENT_ID).evaluateAttributeExpressions().getValue();
        if (clientId != null) {
            clientId = clientId + "-" + this.clientIdCounter.getAndIncrement();
            cachingFactory.setClientId(clientId);
        }
        JmsTemplate jmsTemplate = new JmsTemplate();
        jmsTemplate.setConnectionFactory((ConnectionFactory)cachingFactory);
        jmsTemplate.setPubSubDomain(TOPIC.equals(context.getProperty(DESTINATION_TYPE).getValue()));
        jmsTemplate.setReceiveTimeout(1000L);
        return this.finishBuildingJmsWorker(cachingFactory, jmsTemplate, context);
    }

    static {
        propertyDescriptors.add(CF_SERVICE);
        propertyDescriptors.add(DESTINATION);
        propertyDescriptors.add(DESTINATION_TYPE);
        propertyDescriptors.add(USER);
        propertyDescriptors.add(PASSWORD);
        propertyDescriptors.add(CLIENT_ID);
        propertyDescriptors.add(SESSION_CACHE_SIZE);
        propertyDescriptors.add(MESSAGE_BODY);
        propertyDescriptors.add(CHARSET);
    }
}

