/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.cf;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.jms.cf.CachedJMSConnectionFactoryHandler;
import org.apache.nifi.jms.cf.JndiJmsConnectionFactoryProperties;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.exception.ProcessException;

public class JndiJmsConnectionFactoryHandler
extends CachedJMSConnectionFactoryHandler {
    private final PropertyContext context;
    private final Set<PropertyDescriptor> propertyDescriptors;
    private final ComponentLog logger;

    public JndiJmsConnectionFactoryHandler(ConfigurationContext context, ComponentLog logger) {
        super(logger);
        this.context = context;
        this.propertyDescriptors = context.getProperties().keySet();
        this.logger = logger;
    }

    public JndiJmsConnectionFactoryHandler(ProcessContext context, ComponentLog logger) {
        super(logger);
        this.context = context;
        this.propertyDescriptors = context.getProperties().keySet();
        this.logger = logger;
    }

    public ConnectionFactory createConnectionFactory() {
        return this.lookupConnectionFactory();
    }

    private ConnectionFactory lookupConnectionFactory() {
        try {
            String factoryName = this.context.getProperty(JndiJmsConnectionFactoryProperties.JNDI_CONNECTION_FACTORY_NAME).evaluateAttributeExpressions().getValue().trim();
            this.logger.debug("Looking up Connection Factory with name [{}]", new Object[]{factoryName});
            Context initialContext = this.createInitialContext();
            Object factoryObject = initialContext.lookup(factoryName);
            this.logger.debug("Obtained {} from JNDI", new Object[]{factoryObject});
            if (factoryObject == null) {
                throw new ProcessException("Got a null Factory Object from JNDI");
            }
            if (!(factoryObject instanceof ConnectionFactory)) {
                throw new ProcessException("Successfully performed JNDI lookup with Object Name [" + factoryName + "] but the returned object is not a ConnectionFactory. Instead, is of type " + String.valueOf(factoryObject.getClass()) + " : " + String.valueOf(factoryObject));
            }
            return (ConnectionFactory)JndiJmsConnectionFactoryHandler.instrumentWithClassLoader(factoryObject, Thread.currentThread().getContextClassLoader(), ConnectionFactory.class);
        }
        catch (NamingException ne) {
            throw new ProcessException("Could not obtain JMS Connection Factory from JNDI", (Throwable)ne);
        }
    }

    private Context createInitialContext() throws NamingException {
        String credentials;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.context.getProperty(JndiJmsConnectionFactoryProperties.JNDI_INITIAL_CONTEXT_FACTORY).evaluateAttributeExpressions().getValue().trim());
        env.put("java.naming.provider.url", this.context.getProperty(JndiJmsConnectionFactoryProperties.JNDI_PROVIDER_URL).evaluateAttributeExpressions().getValue().trim());
        String principal = this.context.getProperty(JndiJmsConnectionFactoryProperties.JNDI_PRINCIPAL).evaluateAttributeExpressions().getValue();
        if (principal != null) {
            env.put("java.naming.security.principal", principal);
        }
        if ((credentials = this.context.getProperty(JndiJmsConnectionFactoryProperties.JNDI_CREDENTIALS).getValue()) != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        this.propertyDescriptors.forEach(descriptor -> {
            if (descriptor.isDynamic()) {
                env.put(descriptor.getName(), this.context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
            }
        });
        this.logger.debug("Creating Initial Context using JNDI Environment {}", new Object[]{env});
        InitialContext initialContext = new InitialContext(env);
        return initialContext;
    }

    private static Object instrumentWithClassLoader(final Object obj, final ClassLoader classLoader, Class<?> ... interfaces) {
        InvocationHandler invocationHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Thread thread = Thread.currentThread();
                ClassLoader currentClassLoader = thread.getContextClassLoader();
                try {
                    thread.setContextClassLoader(classLoader);
                    Object object = method.invoke(obj, args);
                    return object;
                }
                finally {
                    thread.setContextClassLoader(currentClassLoader);
                }
            }
        };
        return Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
    }
}

