/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.nifi.jms.processors.JMSWorker;
import org.apache.nifi.logging.ComponentLog;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

class JMSPublisher
extends JMSWorker {
    public static Map<String, JmsPropertySetterEnum> propertySetterMap = new HashMap<String, JmsPropertySetterEnum>();

    JMSPublisher(CachingConnectionFactory connectionFactory, JmsTemplate jmsTemplate, ComponentLog processLog) {
        super(connectionFactory, jmsTemplate, processLog);
        processLog.debug("Created Message Publisher for {}", new Object[]{jmsTemplate});
    }

    void publish(String destinationName, byte[] messageBytes) {
        this.publish(destinationName, messageBytes, null);
    }

    void publish(String destinationName, final byte[] messageBytes, final Map<String, String> flowFileAttributes) {
        this.jmsTemplate.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(messageBytes);
                JMSPublisher.this.setMessageHeaderAndProperties(session, (Message)message, flowFileAttributes);
                return message;
            }
        });
    }

    void publish(String destinationName, final String messageText, final Map<String, String> flowFileAttributes) {
        this.jmsTemplate.send(destinationName, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                TextMessage message = session.createTextMessage(messageText);
                JMSPublisher.this.setMessageHeaderAndProperties(session, (Message)message, flowFileAttributes);
                return message;
            }
        });
    }

    void setMessageHeaderAndProperties(Session session, Message message, Map<String, String> flowFileAttributes) throws JMSException {
        if (flowFileAttributes != null && !flowFileAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : flowFileAttributes.entrySet()) {
                try {
                    if (entry.getKey().equals("jms_deliveryMode")) {
                        this.jmsTemplate.setDeliveryMode(Integer.parseInt(entry.getValue()));
                        this.jmsTemplate.setExplicitQosEnabled(true);
                        continue;
                    }
                    if (entry.getKey().equals("jms_expiration")) {
                        if (!NumberUtils.isCreatable((String)entry.getValue())) continue;
                        long expiration = Long.parseLong(entry.getValue());
                        long ttl = 0L;
                        if (expiration > 0L) {
                            ttl = expiration - Instant.now().toEpochMilli();
                            if (ttl <= 0L) continue;
                            this.jmsTemplate.setTimeToLive(ttl);
                            this.jmsTemplate.setExplicitQosEnabled(true);
                            continue;
                        }
                        if (expiration != 0L) continue;
                        this.jmsTemplate.setTimeToLive(0L);
                        this.jmsTemplate.setExplicitQosEnabled(true);
                        continue;
                    }
                    if (entry.getKey().equals("jms_priority")) {
                        this.jmsTemplate.setPriority(Integer.parseInt(entry.getValue()));
                        this.jmsTemplate.setExplicitQosEnabled(true);
                        continue;
                    }
                    if (entry.getKey().equals("jms_redelivered")) {
                        message.setJMSRedelivered(Boolean.parseBoolean(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_timestamp")) {
                        message.setJMSTimestamp(Long.parseLong(entry.getValue()));
                        continue;
                    }
                    if (entry.getKey().equals("jms_correlationId")) {
                        message.setJMSCorrelationID(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("jms_type")) {
                        message.setJMSType(entry.getValue());
                        continue;
                    }
                    if (entry.getKey().equals("jms_replyTo")) {
                        Destination destination = JMSPublisher.buildDestination(session, entry.getValue());
                        if (destination != null) {
                            message.setJMSReplyTo(destination);
                            continue;
                        }
                        this.logUnbuildableDestination(entry.getValue(), "jms_replyTo");
                        continue;
                    }
                    if (entry.getKey().equals("jms_destination")) {
                        Destination destination = JMSPublisher.buildDestination(session, entry.getValue());
                        if (destination != null) {
                            message.setJMSDestination(destination);
                            continue;
                        }
                        this.logUnbuildableDestination(entry.getValue(), "jms_destination");
                        continue;
                    }
                    String type = flowFileAttributes.getOrDefault(entry.getKey().concat(".type"), "unknown").toLowerCase();
                    propertySetterMap.getOrDefault(type, JmsPropertySetterEnum.STRING).setProperty(message, entry.getKey(), entry.getValue());
                }
                catch (NumberFormatException ne) {
                    this.processLog.warn("Incompatible value for attribute {} [{}] is not a number. Ignoring this attribute.", new Object[]{entry.getKey(), entry.getValue()});
                }
            }
        }
    }

    private void logUnbuildableDestination(String destinationName, String headerName) {
        this.processLog.warn("Failed to determine destination type from destination name '{}'. The '{}' header will not be set.", new Object[]{destinationName, headerName});
    }

    private static Destination buildDestination(Session session, String destinationName) throws JMSException {
        if (destinationName.toLowerCase().contains("topic")) {
            return session.createTopic(destinationName);
        }
        if (destinationName.toLowerCase().contains("queue")) {
            return session.createQueue(destinationName);
        }
        return null;
    }

    static {
        Arrays.stream(JmsPropertySetterEnum.values()).forEach(e -> propertySetterMap.put(e.name().toLowerCase(), (JmsPropertySetterEnum)e));
    }

    public static enum JmsPropertySetterEnum implements JmsPropertySetter
    {
        BOOLEAN((message, name, value) -> message.setBooleanProperty(name, Boolean.parseBoolean(value))),
        BYTE((message, name, value) -> message.setByteProperty(name, Byte.parseByte(value))),
        SHORT((message, name, value) -> message.setShortProperty(name, Short.parseShort(value))),
        INTEGER((message, name, value) -> message.setIntProperty(name, Integer.parseInt(value))),
        LONG((message, name, value) -> message.setLongProperty(name, Long.parseLong(value))),
        FLOAT((message, name, value) -> message.setFloatProperty(name, Float.parseFloat(value))),
        DOUBLE((message, name, value) -> message.setDoubleProperty(name, Double.parseDouble(value))),
        STRING((message, name, value) -> message.setStringProperty(name, value));

        private final JmsPropertySetter setter;

        private JmsPropertySetterEnum(JmsPropertySetter setter) {
            this.setter = setter;
        }

        @Override
        public void setProperty(Message message, String name, String value) throws JMSException, NumberFormatException {
            this.setter.setProperty(message, name, value);
        }
    }

    public static interface JmsPropertySetter {
        public void setProperty(Message var1, String var2, String var3) throws JMSException, NumberFormatException;
    }
}

