/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processors.kafka.pubsub.ConsumerLease;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.RecordSetWriterFactory;

public class ConsumerPool
implements Closeable {
    private final BlockingQueue<SimpleConsumerLease> pooledLeases;
    private final List<String> topics;
    private final Pattern topicPattern;
    private final Map<String, Object> kafkaProperties;
    private final long maxWaitMillis;
    private final ComponentLog logger;
    private final byte[] demarcatorBytes;
    private final String keyEncoding;
    private final String securityProtocol;
    private final String bootstrapServers;
    private final RecordReaderFactory readerFactory;
    private final RecordSetWriterFactory writerFactory;
    private final AtomicLong consumerCreatedCountRef = new AtomicLong();
    private final AtomicLong consumerClosedCountRef = new AtomicLong();
    private final AtomicLong leasesObtainedCountRef = new AtomicLong();

    public ConsumerPool(int maxConcurrentLeases, byte[] demarcator, Map<String, Object> kafkaProperties, List<String> topics, long maxWaitMillis, String keyEncoding, String securityProtocol, String bootstrapServers, ComponentLog logger) {
        this.pooledLeases = new ArrayBlockingQueue<SimpleConsumerLease>(maxConcurrentLeases);
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = demarcator;
        this.keyEncoding = keyEncoding;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = Collections.unmodifiableList(topics);
        this.topicPattern = null;
        this.readerFactory = null;
        this.writerFactory = null;
    }

    public ConsumerPool(int maxConcurrentLeases, byte[] demarcator, Map<String, Object> kafkaProperties, Pattern topics, long maxWaitMillis, String keyEncoding, String securityProtocol, String bootstrapServers, ComponentLog logger) {
        this.pooledLeases = new ArrayBlockingQueue<SimpleConsumerLease>(maxConcurrentLeases);
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = demarcator;
        this.keyEncoding = keyEncoding;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = null;
        this.topicPattern = topics;
        this.readerFactory = null;
        this.writerFactory = null;
    }

    public ConsumerPool(int maxConcurrentLeases, RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, Map<String, Object> kafkaProperties, Pattern topics, long maxWaitMillis, String securityProtocol, String bootstrapServers, ComponentLog logger) {
        this.pooledLeases = new ArrayBlockingQueue<SimpleConsumerLease>(maxConcurrentLeases);
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = null;
        this.keyEncoding = null;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = null;
        this.topicPattern = topics;
    }

    public ConsumerPool(int maxConcurrentLeases, RecordReaderFactory readerFactory, RecordSetWriterFactory writerFactory, Map<String, Object> kafkaProperties, List<String> topics, long maxWaitMillis, String securityProtocol, String bootstrapServers, ComponentLog logger) {
        this.pooledLeases = new ArrayBlockingQueue<SimpleConsumerLease>(maxConcurrentLeases);
        this.maxWaitMillis = maxWaitMillis;
        this.logger = logger;
        this.demarcatorBytes = null;
        this.keyEncoding = null;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
        this.securityProtocol = securityProtocol;
        this.bootstrapServers = bootstrapServers;
        this.kafkaProperties = Collections.unmodifiableMap(kafkaProperties);
        this.topics = topics;
        this.topicPattern = null;
    }

    public ConsumerLease obtainConsumer(ProcessSession session, ProcessContext processContext) {
        SimpleConsumerLease lease = (SimpleConsumerLease)this.pooledLeases.poll();
        if (lease == null) {
            Consumer<byte[], byte[]> consumer = this.createKafkaConsumer();
            this.consumerCreatedCountRef.incrementAndGet();
            lease = new SimpleConsumerLease(consumer);
            if (this.topics != null) {
                consumer.subscribe(this.topics, (ConsumerRebalanceListener)lease);
            } else {
                consumer.subscribe(this.topicPattern, (ConsumerRebalanceListener)lease);
            }
        }
        lease.setProcessSession(session, processContext);
        this.leasesObtainedCountRef.incrementAndGet();
        return lease;
    }

    protected Consumer<byte[], byte[]> createKafkaConsumer() {
        return new KafkaConsumer(this.kafkaProperties);
    }

    @Override
    public void close() {
        ArrayList leases = new ArrayList();
        this.pooledLeases.drainTo(leases);
        leases.stream().forEach(lease -> lease.close(true));
    }

    private void closeConsumer(Consumer<?, ?> consumer) {
        this.consumerClosedCountRef.incrementAndGet();
        try {
            consumer.unsubscribe();
        }
        catch (Exception e) {
            this.logger.warn("Failed while unsubscribing " + consumer, (Throwable)e);
        }
        try {
            consumer.close();
        }
        catch (Exception e) {
            this.logger.warn("Failed while closing " + consumer, (Throwable)e);
        }
    }

    PoolStats getPoolStats() {
        return new PoolStats(this.consumerCreatedCountRef.get(), this.consumerClosedCountRef.get(), this.leasesObtainedCountRef.get());
    }

    static final class PoolStats {
        final long consumerCreatedCount;
        final long consumerClosedCount;
        final long leasesObtainedCount;

        PoolStats(long consumerCreatedCount, long consumerClosedCount, long leasesObtainedCount) {
            this.consumerCreatedCount = consumerCreatedCount;
            this.consumerClosedCount = consumerClosedCount;
            this.leasesObtainedCount = leasesObtainedCount;
        }

        public String toString() {
            return "Created Consumers [" + this.consumerCreatedCount + "]\nClosed Consumers  [" + this.consumerClosedCount + "]\nLeases Obtained   [" + this.leasesObtainedCount + "]\n";
        }
    }

    private class SimpleConsumerLease
    extends ConsumerLease {
        private final Consumer<byte[], byte[]> consumer;
        private volatile ProcessSession session;
        private volatile ProcessContext processContext;
        private volatile boolean closedConsumer;

        private SimpleConsumerLease(Consumer<byte[], byte[]> consumer) {
            super(ConsumerPool.this.maxWaitMillis, consumer, ConsumerPool.this.demarcatorBytes, ConsumerPool.this.keyEncoding, ConsumerPool.this.securityProtocol, ConsumerPool.this.bootstrapServers, ConsumerPool.this.readerFactory, ConsumerPool.this.writerFactory, ConsumerPool.this.logger);
            this.consumer = consumer;
        }

        void setProcessSession(ProcessSession session, ProcessContext context) {
            this.session = session;
            this.processContext = context;
        }

        @Override
        public void yield() {
            if (this.processContext != null) {
                this.processContext.yield();
            }
        }

        @Override
        public ProcessSession getProcessSession() {
            return this.session;
        }

        @Override
        public void close() {
            super.close();
            this.close(false);
        }

        public void close(boolean forceClose) {
            if (this.closedConsumer) {
                return;
            }
            super.close();
            if (this.session != null) {
                this.session.rollback();
                this.setProcessSession(null, null);
            }
            if (forceClose || this.isPoisoned() || !ConsumerPool.this.pooledLeases.offer(this)) {
                this.closedConsumer = true;
                ConsumerPool.this.closeConsumer(this.consumer);
            }
        }
    }
}

