/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka.pubsub;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KafkaProcessorUtils {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    static final AllowableValue UTF8_ENCODING = new AllowableValue("utf-8", "UTF-8 Encoded", "The key is interpreted as a UTF-8 Encoded string.");
    static final AllowableValue HEX_ENCODING = new AllowableValue("hex", "Hex Encoded", "The key is interpreted as arbitrary binary data and is encoded using hexadecimal characters with uppercase letters");
    static final Pattern HEX_KEY_PATTERN = Pattern.compile("(?:[0123456789abcdefABCDEF]{2})+");
    static final String KAFKA_KEY = "kafka.key";
    static final String KAFKA_TOPIC = "kafka.topic";
    static final String KAFKA_PARTITION = "kafka.partition";
    static final String KAFKA_OFFSET = "kafka.offset";
    static final String KAFKA_COUNT = "kafka.count";
    static final AllowableValue SEC_PLAINTEXT = new AllowableValue("PLAINTEXT", "PLAINTEXT", "PLAINTEXT");
    static final AllowableValue SEC_SSL = new AllowableValue("SSL", "SSL", "SSL");
    static final AllowableValue SEC_SASL_PLAINTEXT = new AllowableValue("SASL_PLAINTEXT", "SASL_PLAINTEXT", "SASL_PLAINTEXT");
    static final AllowableValue SEC_SASL_SSL = new AllowableValue("SASL_SSL", "SASL_SSL", "SASL_SSL");
    static final PropertyDescriptor BOOTSTRAP_SERVERS = new PropertyDescriptor.Builder().name("bootstrap.servers").displayName("Kafka Brokers").description("A comma-separated list of known Kafka Brokers in the format <host>:<port>").required(true).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("localhost:9092").build();
    static final PropertyDescriptor SECURITY_PROTOCOL = new PropertyDescriptor.Builder().name("security.protocol").displayName("Security Protocol").description("Protocol used to communicate with brokers. Corresponds to Kafka's 'security.protocol' property.").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(new AllowableValue[]{SEC_PLAINTEXT, SEC_SSL, SEC_SASL_PLAINTEXT, SEC_SASL_SSL}).defaultValue(SEC_PLAINTEXT.getValue()).build();
    static final PropertyDescriptor KERBEROS_PRINCIPLE = new PropertyDescriptor.Builder().name("sasl.kerberos.service.name").displayName("Kerberos Service Name").description("The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config. Corresponds to Kafka's 'security.protocol' property.It is ignored unless one of the SASL options of the <Security Protocol> are selected.").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl.context.service").displayName("SSL Context Service").description("Specifies the SSL Context Service to use for communicating with Kafka.").required(false).identifiesControllerService(SSLContextService.class).build();

    KafkaProcessorUtils() {
    }

    static List<PropertyDescriptor> getCommonPropertyDescriptors() {
        return Arrays.asList(BOOTSTRAP_SERVERS, SECURITY_PROTOCOL, KERBEROS_PRINCIPLE, SSL_CONTEXT_SERVICE);
    }

    static Collection<ValidationResult> validateCommonProperties(ValidationContext validationContext) {
        String valueDeSerializer;
        String keyDeSerializer;
        String valueSerializer;
        String keySerializer;
        String enableAutoCommit;
        String kerberosPrincipal;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        String securityProtocol = validationContext.getProperty(SECURITY_PROTOCOL).getValue();
        if ((SEC_SASL_PLAINTEXT.getValue().equals(securityProtocol) || SEC_SASL_SSL.getValue().equals(securityProtocol)) && ((kerberosPrincipal = validationContext.getProperty(KERBEROS_PRINCIPLE).getValue()) == null || kerberosPrincipal.trim().length() == 0)) {
            results.add(new ValidationResult.Builder().subject(KERBEROS_PRINCIPLE.getDisplayName()).valid(false).explanation("The <" + KERBEROS_PRINCIPLE.getDisplayName() + "> property must be set when <" + SECURITY_PROTOCOL.getDisplayName() + "> is configured as '" + SEC_SASL_PLAINTEXT.getValue() + "' or '" + SEC_SASL_SSL.getValue() + "'.").build());
        }
        boolean sslProtocol = SEC_SSL.getValue().equals(securityProtocol) || SEC_SASL_SSL.getValue().equals(securityProtocol);
        boolean csSet = validationContext.getProperty(SSL_CONTEXT_SERVICE).isSet();
        if (csSet && !sslProtocol) {
            results.add(new ValidationResult.Builder().subject(SECURITY_PROTOCOL.getDisplayName()).valid(false).explanation("If you set the SSL Controller Service you should also choose an SSL based security protocol.").build());
        }
        if (!csSet && sslProtocol) {
            results.add(new ValidationResult.Builder().subject(SSL_CONTEXT_SERVICE.getDisplayName()).valid(false).explanation("If you set to an SSL based protocol you need to set the SSL Controller Service").build());
        }
        if ((enableAutoCommit = validationContext.getProperty(new PropertyDescriptor.Builder().name("enable.auto.commit").build()).getValue()) != null && !enableAutoCommit.toLowerCase().equals("false")) {
            results.add(new ValidationResult.Builder().subject("enable.auto.commit").explanation("Enable auto commit must be false.  It is managed by the processor.").build());
        }
        if ((keySerializer = validationContext.getProperty(new PropertyDescriptor.Builder().name("key.serializer").build()).getValue()) != null && !ByteArraySerializer.class.getName().equals(keySerializer)) {
            results.add(new ValidationResult.Builder().subject("key.serializer").explanation("Key Serializer must be " + ByteArraySerializer.class.getName() + "' was '" + keySerializer + "'").build());
        }
        if ((valueSerializer = validationContext.getProperty(new PropertyDescriptor.Builder().name("value.serializer").build()).getValue()) != null && !ByteArraySerializer.class.getName().equals(valueSerializer)) {
            results.add(new ValidationResult.Builder().subject("value.serializer").explanation("Value Serializer must be " + ByteArraySerializer.class.getName() + "' was '" + valueSerializer + "'").build());
        }
        if ((keyDeSerializer = validationContext.getProperty(new PropertyDescriptor.Builder().name("key.deserializer").build()).getValue()) != null && !ByteArrayDeserializer.class.getName().equals(keyDeSerializer)) {
            results.add(new ValidationResult.Builder().subject("key.deserializer").explanation("Key De-Serializer must be '" + ByteArrayDeserializer.class.getName() + "' was '" + keyDeSerializer + "'").build());
        }
        if ((valueDeSerializer = validationContext.getProperty(new PropertyDescriptor.Builder().name("value.deserializer").build()).getValue()) != null && !ByteArrayDeserializer.class.getName().equals(valueDeSerializer)) {
            results.add(new ValidationResult.Builder().subject("value.deserializer").explanation("Value De-Serializer must be " + ByteArrayDeserializer.class.getName() + "' was '" + valueDeSerializer + "'").build());
        }
        return results;
    }

    static String buildTransitURI(String securityProtocol, String brokers, String topic) {
        StringBuilder builder = new StringBuilder();
        builder.append(securityProtocol);
        builder.append("://");
        builder.append(brokers);
        builder.append("/");
        builder.append(topic);
        return builder.toString();
    }

    static void buildCommonKafkaProperties(ProcessContext context, Class<?> kafkaConfigClass, Map<String, Object> mapToPopulate) {
        for (PropertyDescriptor propertyDescriptor : context.getProperties().keySet()) {
            if (propertyDescriptor.equals((Object)SSL_CONTEXT_SERVICE)) {
                SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
                if (sslContextService != null && sslContextService.isKeyStoreConfigured()) {
                    mapToPopulate.put("ssl.keystore.location", sslContextService.getKeyStoreFile());
                    mapToPopulate.put("ssl.keystore.password", sslContextService.getKeyStorePassword());
                    String keyPass = sslContextService.getKeyPassword() == null ? sslContextService.getKeyStorePassword() : sslContextService.getKeyPassword();
                    mapToPopulate.put("ssl.key.password", keyPass);
                    mapToPopulate.put("ssl.keystore.type", sslContextService.getKeyStoreType());
                }
                if (sslContextService != null && sslContextService.isTrustStoreConfigured()) {
                    mapToPopulate.put("ssl.truststore.location", sslContextService.getTrustStoreFile());
                    mapToPopulate.put("ssl.truststore.password", sslContextService.getTrustStorePassword());
                    mapToPopulate.put("ssl.truststore.type", sslContextService.getTrustStoreType());
                }
            }
            String propertyName = propertyDescriptor.getName();
            String propertyValue = propertyDescriptor.isExpressionLanguageSupported() ? context.getProperty(propertyDescriptor).evaluateAttributeExpressions().getValue() : context.getProperty(propertyDescriptor).getValue();
            if (propertyValue == null) continue;
            if (propertyName.endsWith(".ms") && !StringUtils.isNumeric((CharSequence)propertyValue.trim())) {
                propertyValue = String.valueOf(FormatUtils.getTimeDuration((String)propertyValue.trim(), (TimeUnit)TimeUnit.MILLISECONDS));
            }
            if (!KafkaProcessorUtils.isStaticStringFieldNamePresent(propertyName, kafkaConfigClass, CommonClientConfigs.class, SslConfigs.class, SaslConfigs.class)) continue;
            mapToPopulate.put(propertyName, propertyValue);
        }
    }

    private static boolean isStaticStringFieldNamePresent(String name, Class<?> ... classes) {
        return KafkaProcessorUtils.getPublicStaticStringFieldValues(classes).contains(name);
    }

    private static Set<String> getPublicStaticStringFieldValues(Class<?> ... classes) {
        HashSet<String> strings = new HashSet<String>();
        for (Class<?> classType : classes) {
            for (Field field : classType.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !field.getType().equals(String.class)) continue;
                try {
                    strings.add(String.valueOf(field.get(null)));
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
        return strings;
    }

    static final class KafkaConfigValidator
    implements Validator {
        final Class<?> classType;

        public KafkaConfigValidator(Class<?> classType) {
            this.classType = classType;
        }

        public ValidationResult validate(String subject, String value, ValidationContext context) {
            boolean knownValue = KafkaProcessorUtils.isStaticStringFieldNamePresent(subject, new Class[]{this.classType, CommonClientConfigs.class, SslConfigs.class, SaslConfigs.class});
            return new ValidationResult.Builder().subject(subject).explanation("Must be a known configuration parameter for this kafka client").valid(knownValue).build();
        }
    }
}

