/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kafka;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;

class PublishingContext {
    private final InputStream contentStream;
    private final String topic;
    private final int lastAckedMessageIndex;
    private volatile Integer partitionId;
    private volatile int maxRequestSize = 0x100000;
    private volatile boolean maxRequestSizeSet;
    private volatile byte[] keyBytes;
    private volatile byte[] delimiterBytes;

    PublishingContext(InputStream contentStream, String topic) {
        this(contentStream, topic, -1);
    }

    PublishingContext(InputStream contentStream, String topic, int lastAckedMessageIndex) {
        this.validateInput(contentStream, topic, lastAckedMessageIndex);
        this.contentStream = contentStream;
        this.topic = topic;
        this.lastAckedMessageIndex = lastAckedMessageIndex;
    }

    public String toString() {
        return "topic: '" + this.topic + "'; delimiter: '" + new String(this.delimiterBytes, StandardCharsets.UTF_8) + "'";
    }

    int getLastAckedMessageIndex() {
        return this.lastAckedMessageIndex;
    }

    int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    byte[] getKeyBytes() {
        return this.keyBytes;
    }

    Integer getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
    }

    byte[] getDelimiterBytes() {
        return this.delimiterBytes;
    }

    InputStream getContentStream() {
        return this.contentStream;
    }

    String getTopic() {
        return this.topic;
    }

    void setKeyBytes(byte[] keyBytes) {
        if (this.keyBytes == null) {
            if (keyBytes != null) {
                this.assertBytesValid(keyBytes);
                this.keyBytes = keyBytes;
            }
        } else {
            throw new IllegalArgumentException("'keyBytes' can only be set once per instance");
        }
    }

    void setDelimiterBytes(byte[] delimiterBytes) {
        if (this.delimiterBytes == null) {
            if (delimiterBytes != null) {
                this.assertBytesValid(delimiterBytes);
                this.delimiterBytes = delimiterBytes;
            }
        } else {
            throw new IllegalArgumentException("'delimiterBytes' can only be set once per instance");
        }
    }

    void setMaxRequestSize(int maxRequestSize) {
        if (!this.maxRequestSizeSet) {
            if (maxRequestSize <= 0) {
                throw new IllegalArgumentException("'maxRequestSize' must be > 0");
            }
        } else {
            throw new IllegalArgumentException("'maxRequestSize' can only be set once per instance");
        }
        this.maxRequestSize = maxRequestSize;
        this.maxRequestSizeSet = true;
    }

    private void assertBytesValid(byte[] bytes) {
        if (bytes != null && bytes.length == 0) {
            throw new IllegalArgumentException("'bytes' must not be empty");
        }
    }

    private void validateInput(InputStream contentStream, String topic, int lastAckedMessageIndex) {
        if (contentStream == null) {
            throw new IllegalArgumentException("'contentStream' must not be null");
        }
        if (topic == null || topic.trim().length() == 0) {
            throw new IllegalArgumentException("'topic' must not be null or empty");
        }
        if (lastAckedMessageIndex < -1) {
            throw new IllegalArgumentException("'lastAckedMessageIndex' must be >= -1");
        }
    }
}

