/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.LoginIdentityProviderConfigurationContext;
import org.apache.nifi.authentication.LoginIdentityProviderInitializationContext;
import org.apache.nifi.authentication.exception.IdentityAccessException;
import org.apache.nifi.authentication.exception.InvalidLoginCredentialsException;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.authentication.exception.ProviderDestructionException;
import org.apache.nifi.kerberos.KerberosUserDetailsService;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.kerberos.authentication.KerberosAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosClient;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosClient;

public class KerberosProvider
implements LoginIdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(KerberosProvider.class);
    private KerberosAuthenticationProvider provider;
    private String issuer;
    private long expiration;

    public final void initialize(LoginIdentityProviderInitializationContext initializationContext) throws ProviderCreationException {
        this.issuer = this.getClass().getSimpleName();
    }

    public final void onConfigured(LoginIdentityProviderConfigurationContext configurationContext) throws ProviderCreationException {
        String rawExpiration = configurationContext.getProperty("Authentication Expiration");
        if (StringUtils.isBlank((CharSequence)rawExpiration)) {
            throw new ProviderCreationException("The Authentication Expiration must be specified.");
        }
        try {
            this.expiration = FormatUtils.getTimeDuration((String)rawExpiration, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (IllegalArgumentException iae) {
            throw new ProviderCreationException(String.format("The Expiration Duration '%s' is not a valid time duration", rawExpiration));
        }
        this.provider = new KerberosAuthenticationProvider();
        SunJaasKerberosClient client = new SunJaasKerberosClient();
        client.setDebug(true);
        this.provider.setKerberosClient((KerberosClient)client);
        this.provider.setUserDetailsService((UserDetailsService)new KerberosUserDetailsService());
    }

    public final AuthenticationResponse authenticate(LoginCredentials credentials) throws InvalidLoginCredentialsException, IdentityAccessException {
        if (this.provider == null) {
            throw new IdentityAccessException("The Kerberos authentication provider is not initialized.");
        }
        try {
            UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)credentials.getUsername(), (Object)credentials.getPassword());
            logger.debug("Created authentication token for principal {} with name {} and is authenticated {}", new Object[]{token.getPrincipal(), token.getName(), token.isAuthenticated()});
            Authentication authentication = this.provider.authenticate((Authentication)token);
            logger.debug("Ran provider.authenticate() and returned authentication for principal {} with name {} and is authenticated {}", new Object[]{authentication.getPrincipal(), authentication.getName(), authentication.isAuthenticated()});
            return new AuthenticationResponse(authentication.getName(), credentials.getUsername(), this.expiration, this.issuer);
        }
        catch (AuthenticationException e) {
            throw new InvalidLoginCredentialsException(e.getMessage(), (Throwable)e);
        }
    }

    public final void preDestruction() throws ProviderDestructionException {
    }
}

