/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

public abstract class AbstractKerberosUserService
extends AbstractControllerService
implements KerberosUserService {
    static final PropertyDescriptor PRINCIPAL = new PropertyDescriptor.Builder().name("Kerberos Principal").description("Kerberos principal to authenticate as. Requires nifi.kerberos.krb5.file to be set in your nifi.properties").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    private File kerberosConfigFile;
    private volatile String principal;

    protected final void init(ControllerServiceInitializationContext config) throws InitializationException {
        this.kerberosConfigFile = config.getKerberosConfigurationFile();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (this.kerberosConfigFile == null) {
            results.add(new ValidationResult.Builder().subject("Kerberos Configuration File").valid(false).explanation("The nifi.kerberos.krb5.file property must be set in nifi.properties in order to use Kerberos authentication").build());
        } else if (!this.kerberosConfigFile.canRead()) {
            results.add(new ValidationResult.Builder().subject("Kerberos Configuration File").valid(false).explanation("Unable to read configured Kerberos Configuration File " + this.kerberosConfigFile.getAbsolutePath() + ", which is specified in nifi.properties. Please ensure that the path is valid and that NiFi has adequate permissions to read the file.").build());
        }
        return results;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(2);
        properties.add(PRINCIPAL);
        properties.addAll(this.getAdditionalProperties());
        return properties;
    }

    @OnEnabled
    public void setConfiguredValues(ConfigurationContext context) {
        this.principal = context.getProperty(PRINCIPAL).evaluateAttributeExpressions().getValue();
        this.setAdditionalConfiguredValues(context);
    }

    protected String getPrincipal() {
        return this.principal;
    }

    protected abstract List<PropertyDescriptor> getAdditionalProperties();

    protected abstract void setAdditionalConfiguredValues(ConfigurationContext var1);
}

