/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.AbstractKerberosUserService;
import org.apache.nifi.kerberos.SelfContainedKerberosUserService;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosUser;

@CapabilityDescription(value="Provides a mechanism for creating a KerberosUser from a principal and keytab that other components are able to use in order to perform authentication using Kerberos. By encapsulating this information into a Controller Service and allowing other components to make use of it (as opposed to specifying the principal and keytab directly in the processor) an administrator is able to choose which users are allowed to use which keytabs and principals. This provides a more robust security model for multi-tenant use cases.")
@Tags(value={"Kerberos", "Keytab", "Principal", "Credentials", "Authentication", "Security"})
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.ACCESS_KEYTAB, explanation="Allows user to define a Keytab and principal that can then be used by other components.")})
public class KerberosKeytabUserService
extends AbstractKerberosUserService
implements SelfContainedKerberosUserService {
    static final PropertyDescriptor KEYTAB = new PropertyDescriptor.Builder().name("Kerberos Keytab").description("Kerberos keytab associated with the principal.").identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(true).build();
    private volatile String keytab;

    @Override
    protected List<PropertyDescriptor> getAdditionalProperties() {
        return Collections.singletonList(KEYTAB);
    }

    @Override
    protected void setAdditionalConfiguredValues(ConfigurationContext context) {
        this.keytab = context.getProperty(KEYTAB).evaluateAttributeExpressions().getValue();
    }

    public KerberosUser createKerberosUser() {
        return new KerberosKeytabUser(this.getPrincipal(), this.keytab);
    }
}

