/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kite;

import com.google.common.annotations.VisibleForTesting;
import org.apache.avro.file.CodecFactory;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.processors.kite.AbstractKiteProcessor;

abstract class AbstractKiteConvertProcessor
extends AbstractKiteProcessor {
    @VisibleForTesting
    static final PropertyDescriptor COMPRESSION_TYPE = new PropertyDescriptor.Builder().name("kite-compression-type").displayName("Compression type").description("Compression type to use when writting Avro files. Default is Snappy.").allowableValues((Enum[])CodecType.values()).defaultValue(CodecType.SNAPPY.toString()).build();

    AbstractKiteConvertProcessor() {
    }

    protected CodecFactory getCodecFactory(String property) {
        CodecType type = CodecType.valueOf(property);
        switch (type) {
            case BZIP2: {
                return CodecFactory.bzip2Codec();
            }
            case DEFLATE: {
                return CodecFactory.deflateCodec((int)-1);
            }
            case NONE: {
                return CodecFactory.nullCodec();
            }
            case LZO: {
                return CodecFactory.xzCodec((int)6);
            }
        }
        return CodecFactory.snappyCodec();
    }

    public static enum CodecType {
        BZIP2,
        DEFLATE,
        NONE,
        SNAPPY,
        LZO;

    }
}

