/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kite;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;

public class AvroRecordConverter {
    private final Schema inputSchema;
    private final Schema outputSchema;
    private final Map<String, String> fieldMapping;
    private final Locale locale;
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();

    public AvroRecordConverter(Schema inputSchema, Schema outputSchema, Map<String, String> fieldMapping) {
        this(inputSchema, outputSchema, fieldMapping, DEFAULT_LOCALE);
    }

    public AvroRecordConverter(Schema inputSchema, Schema outputSchema, Map<String, String> fieldMapping, Locale locale) {
        this.inputSchema = inputSchema;
        this.outputSchema = outputSchema;
        this.fieldMapping = Maps.newHashMapWithExpectedSize((int)fieldMapping.size());
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            this.fieldMapping.put(entry.getValue(), entry.getKey());
        }
        this.locale = locale;
    }

    public Collection<String> getUnmappedFields() {
        ArrayList result = Lists.newArrayList();
        for (Schema.Field f : this.outputSchema.getFields()) {
            String fieldName = f.name();
            if (this.fieldMapping.containsKey(fieldName)) {
                fieldName = this.fieldMapping.get(fieldName);
            }
            Schema currentSchema = this.inputSchema;
            while (fieldName.contains(".")) {
                int dotIndex = fieldName.indexOf(46);
                String entityName = fieldName.substring(0, dotIndex);
                if ((currentSchema = AvroRecordConverter.getNonNullSchema(currentSchema)).getField(entityName) == null) break;
                currentSchema = currentSchema.getField(entityName).schema();
                fieldName = fieldName.substring(dotIndex + 1);
            }
            if (currentSchema != null && AvroRecordConverter.getNonNullSchema(currentSchema).getField(fieldName) != null) continue;
            result.add(f.name());
        }
        return result;
    }

    public GenericData.Record convert(GenericData.Record input) throws AvroConversionException {
        GenericData.Record result = new GenericData.Record(this.outputSchema);
        for (Schema.Field outputField : this.outputSchema.getFields()) {
            String inputFieldName = outputField.name();
            if (this.fieldMapping.containsKey(outputField.name())) {
                inputFieldName = this.fieldMapping.get(outputField.name());
            }
            GenericData.Record currentRecord = input;
            Schema currentSchema = AvroRecordConverter.getNonNullSchema(this.inputSchema);
            while (inputFieldName.contains(".")) {
                int dotIndex = inputFieldName.indexOf(46);
                String entityName = inputFieldName.substring(0, dotIndex);
                Object innerRecord = currentRecord.get(currentSchema.getField(entityName).pos());
                if (innerRecord == null) {
                    currentRecord = null;
                    break;
                }
                if (innerRecord != null && !(innerRecord instanceof IndexedRecord)) {
                    throw new AvroConversionException(inputFieldName + " stepped through a non-record");
                }
                currentRecord = (IndexedRecord)innerRecord;
                currentSchema = currentSchema.getField(entityName).schema();
                currentSchema = AvroRecordConverter.getNonNullSchema(currentSchema);
                inputFieldName = inputFieldName.substring(dotIndex + 1);
            }
            Schema.Field f = currentSchema.getField(inputFieldName);
            if (currentRecord == null) {
                Schema s = null;
                if (f != null) {
                    s = f.schema();
                }
                result.put(outputField.name(), this.convertData(null, s, outputField.schema()));
                continue;
            }
            result.put(outputField.name(), this.convertData(currentRecord.get(f.pos()), f.schema(), outputField.schema()));
        }
        return result;
    }

    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public Schema getOutputSchema() {
        return this.outputSchema;
    }

    private Object convertData(Object content, Schema inputSchema, Schema outputSchema) throws AvroConversionException {
        if (content == null) {
            if (AvroRecordConverter.supportsNull(outputSchema)) {
                return null;
            }
            throw new AvroConversionException("Output schema " + outputSchema + " does not support null");
        }
        Schema nonNillInput = AvroRecordConverter.getNonNullSchema(inputSchema);
        Schema nonNillOutput = AvroRecordConverter.getNonNullSchema(outputSchema);
        if (nonNillInput.getType().equals((Object)nonNillOutput.getType())) {
            return content;
        }
        if (nonNillOutput.getType() == Schema.Type.STRING) {
            return content.toString();
        }
        Scanner scanner = new Scanner(content.toString());
        scanner.useLocale(this.locale);
        switch (nonNillOutput.getType()) {
            case LONG: {
                if (scanner.hasNextLong()) {
                    return scanner.nextLong();
                }
                throw new AvroConversionException("Cannot convert " + content + " to long");
            }
            case INT: {
                if (scanner.hasNextInt()) {
                    return scanner.nextInt();
                }
                throw new AvroConversionException("Cannot convert " + content + " to int");
            }
            case DOUBLE: {
                if (scanner.hasNextDouble()) {
                    return scanner.nextDouble();
                }
                throw new AvroConversionException("Cannot convert " + content + " to double");
            }
            case FLOAT: {
                if (scanner.hasNextFloat()) {
                    return Float.valueOf(scanner.nextFloat());
                }
                throw new AvroConversionException("Cannot convert " + content + " to float");
            }
        }
        throw new AvroConversionException("Cannot convert to type " + nonNillOutput.getType());
    }

    protected static Schema getNonNullSchema(Schema s) {
        if (s.getType() == Schema.Type.UNION) {
            List types = s.getTypes();
            boolean foundOne = false;
            Schema result = s;
            for (Schema type : types) {
                if (type.getType().equals((Object)Schema.Type.NULL)) continue;
                Preconditions.checkArgument((!foundOne ? 1 : 0) != 0, (Object)"Cannot handle union of two non-null types");
                foundOne = true;
                result = type;
            }
            return result;
        }
        return s;
    }

    protected static boolean supportsNull(Schema s) {
        if (s.getType() == Schema.Type.NULL) {
            return true;
        }
        if (s.getType() == Schema.Type.UNION) {
            for (Schema type : s.getTypes()) {
                if (type.getType() != Schema.Type.NULL) continue;
                return true;
            }
        }
        return false;
    }

    public class AvroConversionException
    extends Exception {
        public AvroConversionException(String string, IOException e) {
            super(string, e);
        }

        public AvroConversionException(String string) {
            super(string);
        }
    }
}

