/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.kite;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Map;

class FailureTracker {
    private static final Splitter REASON_SEPARATOR = Splitter.on((char)':').limit(2);
    private final Map<String, String> examples = Maps.newLinkedHashMap();
    private final Map<String, Integer> occurrences = Maps.newLinkedHashMap();
    long count = 0L;

    FailureTracker() {
    }

    public void add(Throwable throwable) {
        this.add(FailureTracker.reason(throwable));
    }

    public void add(String reason) {
        ++this.count;
        String problem = (String)Iterators.getNext(REASON_SEPARATOR.split((CharSequence)reason).iterator(), (Object)"Unknown");
        if (this.examples.containsKey(problem)) {
            this.occurrences.put(problem, this.occurrences.get(problem) + 1);
        } else {
            this.examples.put(problem, reason);
            this.occurrences.put(problem, 1);
        }
    }

    public long count() {
        return this.count;
    }

    public String summary() {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String problem : this.examples.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(this.examples.get(problem));
            int similar = this.occurrences.get(problem) - 1;
            if (similar == 1) {
                sb.append(" (1 similar failure)");
                continue;
            }
            if (similar <= 1) continue;
            sb.append(" (").append(similar).append(" similar failures)");
        }
        return sb.toString();
    }

    private static String reason(Throwable t) {
        StringBuilder sb = new StringBuilder();
        for (Throwable current = t; current != null; current = current.getCause()) {
            if (current != t) {
                sb.append(": ");
            }
            sb.append(current.getMessage());
        }
        return sb.toString();
    }
}

