/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.lumberjack.frame;

import org.apache.nifi.processors.lumberjack.frame.LumberjackFrameException;

@Deprecated
public class LumberjackFrame {
    public static final byte DELIMITER = 10;
    private final byte version;
    private final byte frameType;
    private final byte[] payload;
    private final long dataSize;
    private final long seqNumber;

    private LumberjackFrame(Builder builder) {
        this.version = builder.version;
        this.frameType = builder.frameType;
        this.payload = builder.payload;
        this.dataSize = builder.dataSize;
        this.seqNumber = builder.seqNumber;
        if (this.version < 2 || this.payload.length < 0) {
            throw new LumberjackFrameException("Invalid Frame");
        }
    }

    public long getSeqNumber() {
        return this.seqNumber;
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getFrameType() {
        return this.frameType;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public static class Builder {
        byte version;
        byte frameType;
        byte[] payload;
        long dataSize;
        long seqNumber;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.version = (byte)-1;
            this.seqNumber = -1L;
            this.frameType = (byte)-1;
            this.payload = null;
        }

        public Builder version(byte version) {
            this.version = version;
            return this;
        }

        public Builder seqNumber(long seqNumber) {
            this.seqNumber = seqNumber;
            return this;
        }

        public Builder frameType(byte frameType) {
            this.frameType = frameType;
            return this;
        }

        public Builder dataSize(long dataSize) {
            this.dataSize = dataSize;
            return this;
        }

        public Builder payload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public LumberjackFrame build() {
            return new LumberjackFrame(this);
        }
    }
}

