/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class ArrayListRecordWriter
extends AbstractControllerService
implements RecordSetWriterFactory {
    private final List<Record> records = new ArrayList<Record>();
    private final RecordSchema schema;

    public ArrayListRecordWriter(RecordSchema schema) {
        this.schema = schema;
    }

    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) {
        return this.schema;
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream out) {
        return new ArrayListRecordSetWriter(this.records);
    }

    public List<Record> getRecordsWritten() {
        return Collections.unmodifiableList(this.records);
    }

    public static class ArrayListRecordSetWriter
    implements RecordSetWriter {
        private final List<Record> records;

        public ArrayListRecordSetWriter(List<Record> records) {
            this.records = records;
        }

        public WriteResult write(RecordSet recordSet) throws IOException {
            Record record;
            int count = 0;
            while ((record = recordSet.next()) != null) {
                this.records.add(record);
                ++count;
            }
            return WriteResult.of((int)count, Collections.emptyMap());
        }

        public void beginRecordSet() {
        }

        public WriteResult finishRecordSet() {
            return null;
        }

        public WriteResult write(Record record) {
            this.records.add(record);
            return WriteResult.of((int)1, Collections.emptyMap());
        }

        public String getMimeType() {
            return null;
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

