/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;

public class CommaSeparatedRecordReader
extends AbstractControllerService
implements RecordReaderFactory {
    private int failAfterN;
    private int recordCount = 0;

    public CommaSeparatedRecordReader() {
        this(-1);
    }

    public CommaSeparatedRecordReader(int failAfterN) {
        this.failAfterN = failAfterN;
    }

    public void failAfter(int failAfterN) {
        this.failAfterN = failAfterN;
    }

    public RecordReader createRecordReader(Map<String, String> variables, InputStream in, ComponentLog logger) throws IOException, SchemaNotFoundException {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        final ArrayList<RecordField> fields = new ArrayList<RecordField>();
        String headerLine = reader.readLine();
        for (String colName : headerLine.split(",")) {
            fields.add(new RecordField(colName.trim(), RecordFieldType.STRING.getDataType()));
        }
        return new RecordReader(){

            public void close() throws IOException {
                reader.close();
            }

            public Record nextRecord(boolean coerceTypes, boolean dropUnknown) throws IOException, MalformedRecordException {
                if (CommaSeparatedRecordReader.this.failAfterN > -1 && CommaSeparatedRecordReader.this.recordCount >= CommaSeparatedRecordReader.this.failAfterN) {
                    throw new MalformedRecordException("Intentional Unit Test Exception because " + CommaSeparatedRecordReader.this.recordCount + " records have been read");
                }
                String nextLine = reader.readLine();
                if (nextLine == null) {
                    return null;
                }
                CommaSeparatedRecordReader.this.recordCount++;
                String[] values = nextLine.split(",");
                HashMap<String, String> valueMap = new HashMap<String, String>();
                int i = 0;
                for (RecordField field : fields) {
                    String fieldName = field.getFieldName();
                    valueMap.put(fieldName, values[i++].trim());
                }
                return new MapRecord((RecordSchema)new SimpleRecordSchema(fields), valueMap);
            }

            public RecordSchema getSchema() {
                return new SimpleRecordSchema(fields);
            }
        };
    }
}

