/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.WriteResult;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.RecordSet;

public class MockRecordWriter
extends AbstractControllerService
implements RecordSetWriterFactory {
    private final String header;
    private final int failAfterN;
    private final boolean quoteValues;
    private final boolean bufferOutput;

    public MockRecordWriter() {
        this(null);
    }

    public MockRecordWriter(String header) {
        this(header, true, -1, false);
    }

    public MockRecordWriter(String header, boolean quoteValues) {
        this(header, quoteValues, false);
    }

    public MockRecordWriter(String header, boolean quoteValues, int failAfterN) {
        this(header, quoteValues, failAfterN, false);
    }

    public MockRecordWriter(String header, boolean quoteValues, boolean bufferOutput) {
        this(header, quoteValues, -1, bufferOutput);
    }

    public MockRecordWriter(String header, boolean quoteValues, int failAfterN, boolean bufferOutput) {
        this.header = header;
        this.quoteValues = quoteValues;
        this.failAfterN = failAfterN;
        this.bufferOutput = bufferOutput;
    }

    public RecordSchema getSchema(Map<String, String> variables, RecordSchema readSchema) throws SchemaNotFoundException, IOException {
        return new SimpleRecordSchema(Collections.emptyList());
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema schema, OutputStream rawOut) {
        final OutputStream out = this.bufferOutput ? new BufferedOutputStream(rawOut) : rawOut;
        return new RecordSetWriter(){
            private int recordCount = 0;
            private boolean headerWritten = false;

            public void flush() throws IOException {
                out.flush();
            }

            public WriteResult write(RecordSet rs) throws IOException {
                if (MockRecordWriter.this.header != null && !this.headerWritten) {
                    out.write(MockRecordWriter.this.header.getBytes());
                    out.write("\n".getBytes());
                    this.headerWritten = true;
                }
                int recordCount = 0;
                Record record = null;
                while ((record = rs.next()) != null) {
                    if (++recordCount > MockRecordWriter.this.failAfterN && MockRecordWriter.this.failAfterN > -1) {
                        throw new IOException("Unit Test intentionally throwing IOException after " + MockRecordWriter.this.failAfterN + " records were written");
                    }
                    int numCols = record.getSchema().getFieldCount();
                    int i = 0;
                    for (String fieldName : record.getSchema().getFieldNames()) {
                        String val = record.getAsString(fieldName);
                        if (val != null) {
                            if (MockRecordWriter.this.quoteValues) {
                                out.write("\"".getBytes());
                                out.write(val.getBytes());
                                out.write("\"".getBytes());
                            } else {
                                out.write(val.getBytes());
                            }
                        }
                        if (i++ >= numCols - 1) continue;
                        out.write(",".getBytes());
                    }
                    out.write("\n".getBytes());
                }
                return WriteResult.of((int)recordCount, Collections.emptyMap());
            }

            public String getMimeType() {
                return "text/plain";
            }

            public WriteResult write(Record record) throws IOException {
                if (++this.recordCount > MockRecordWriter.this.failAfterN && MockRecordWriter.this.failAfterN > -1) {
                    throw new IOException("Unit Test intentionally throwing IOException after " + MockRecordWriter.this.failAfterN + " records were written");
                }
                if (MockRecordWriter.this.header != null && !this.headerWritten) {
                    out.write(MockRecordWriter.this.header.getBytes());
                    out.write("\n".getBytes());
                    this.headerWritten = true;
                }
                int numCols = record.getSchema().getFieldCount();
                int i = 0;
                for (String fieldName : record.getSchema().getFieldNames()) {
                    String val = record.getAsString(fieldName);
                    if (val != null) {
                        if (MockRecordWriter.this.quoteValues) {
                            out.write("\"".getBytes());
                            out.write(val.getBytes());
                            out.write("\"".getBytes());
                        } else {
                            out.write(val.getBytes());
                        }
                    }
                    if (i++ >= numCols - 1) continue;
                    out.write(",".getBytes());
                }
                out.write("\n".getBytes());
                return WriteResult.of((int)1, Collections.emptyMap());
            }

            public void close() throws IOException {
                out.close();
            }

            public void beginRecordSet() throws IOException {
            }

            public WriteResult finishRecordSet() throws IOException {
                return WriteResult.of((int)this.recordCount, Collections.emptyMap());
            }
        };
    }
}

