/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.serialization.record;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaRegistry;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.util.Tuple;

public class MockSchemaRegistry
extends AbstractControllerService
implements SchemaRegistry {
    private final ConcurrentMap<String, RecordSchema> schemaNameMap = new ConcurrentHashMap<String, RecordSchema>();
    private final ConcurrentMap<Tuple<Long, Integer>, RecordSchema> schemaIdVersionMap = new ConcurrentHashMap<Tuple<Long, Integer>, RecordSchema>();

    public void addSchema(String name, RecordSchema schema) {
        this.schemaNameMap.put(name, schema);
    }

    private RecordSchema retrieveSchemaByName(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        Optional schemaName = schemaIdentifier.getName();
        if (!schemaName.isPresent()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Name is not present");
        }
        return (RecordSchema)this.schemaNameMap.get(schemaName.get());
    }

    private RecordSchema retrieveSchemaByIdAndVersion(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        OptionalLong schemaId = schemaIdentifier.getIdentifier();
        if (!schemaId.isPresent()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Id is not present");
        }
        OptionalInt version = schemaIdentifier.getVersion();
        if (!version.isPresent()) {
            throw new SchemaNotFoundException("Cannot retrieve schema because Schema Version is not present");
        }
        Tuple tuple = new Tuple((Object)schemaId.getAsLong(), (Object)version.getAsInt());
        RecordSchema schema = (RecordSchema)this.schemaIdVersionMap.get(tuple);
        return schema;
    }

    public RecordSchema retrieveSchema(SchemaIdentifier schemaIdentifier) throws IOException, SchemaNotFoundException {
        if (schemaIdentifier.getName().isPresent()) {
            return this.retrieveSchemaByName(schemaIdentifier);
        }
        return this.retrieveSchemaByIdAndVersion(schemaIdentifier);
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return EnumSet.allOf(SchemaField.class);
    }
}

