/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb.gridfs;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.mongodb.MongoDBClientService;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processors.mongodb.QueryHelper;
import org.apache.nifi.processors.mongodb.gridfs.AbstractGridFSProcessor;
import org.apache.nifi.util.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="gridfs.file.metadata", description="The custom metadata stored with a file is attached to this property if it exists.")})
@Tags(value={"fetch", "gridfs", "mongo"})
@CapabilityDescription(value="Retrieves one or more files from a GridFS bucket by file name or by a user-defined query.")
public class FetchGridFS
extends AbstractGridFSProcessor
implements QueryHelper {
    static final String METADATA_ATTRIBUTE = "gridfs.file.metadata";
    static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("gridfs-query").displayName("Query").description("A valid MongoDB query to use to fetch one or more files from GridFS.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).required(false).build();
    static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original input flowfile goes to this relationship if the query does not cause an error").build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS;
    static final Set<Relationship> RELATIONSHIP_SET;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIP_SET;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    private String getQuery(ProcessSession session, ProcessContext context, FlowFile input) throws IOException {
        String queryString;
        if (context.getProperty(FILE_NAME).isSet()) {
            String fileName = context.getProperty(FILE_NAME).evaluateAttributeExpressions(input).getValue();
            queryString = String.format("{ \"filename\": \"%s\"}", fileName);
        } else if (context.getProperty(QUERY).isSet()) {
            queryString = context.getProperty(QUERY).evaluateAttributeExpressions(input).getValue();
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            session.exportTo(input, (OutputStream)out);
            out.close();
            queryString = new String(out.toByteArray());
        }
        return queryString;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService = (MongoDBClientService)context.getProperty(CLIENT_SERVICE).asControllerService(MongoDBClientService.class);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        block10: {
            String queryStr;
            FlowFile input = session.get();
            if (input == null) {
                return;
            }
            String operatingMode = context.getProperty(OPERATION_MODE).getValue();
            Map originalAttributes = input.getAttributes();
            try {
                queryStr = this.getQuery(session, context, input);
                if (StringUtils.isEmpty((String)queryStr)) {
                    this.getLogger().error("No query could be found or built from the supplied input.");
                    session.transfer(input, REL_FAILURE);
                    return;
                }
            }
            catch (IOException ex) {
                this.getLogger().error("No query could be found from supplied input", (Throwable)ex);
                session.transfer(input, REL_FAILURE);
                return;
            }
            Document query = Document.parse((String)queryStr);
            try {
                GridFSBucket bucket = this.getBucket(input, context);
                String queryPtr = queryStr;
                FlowFile parent = operatingMode.equals(MODE_ONE_COMMIT.getValue()) ? input : null;
                MongoCursor it = bucket.find((Bson)query).iterator();
                if (operatingMode.equals(MODE_MANY_COMMITS.getValue())) {
                    session.transfer(input, REL_ORIGINAL);
                    input = null;
                }
                while (it.hasNext()) {
                    GridFSFile gridFSFile = (GridFSFile)it.next();
                    this.handleFile(bucket, session, context, parent, gridFSFile, queryPtr);
                    if (!operatingMode.equals(MODE_MANY_COMMITS.getValue())) continue;
                    session.commit();
                }
                if (input != null) {
                    session.transfer(input, REL_ORIGINAL);
                }
            }
            catch (Exception ex) {
                this.getLogger().error("An error occurred wile trying to run the query.", (Throwable)ex);
                if (input != null && operatingMode.equals(MODE_ONE_COMMIT.getValue())) {
                    session.transfer(input, REL_FAILURE);
                }
                if (input == null || !operatingMode.equals(MODE_MANY_COMMITS.getValue())) break block10;
                String queryPtr = queryStr;
                FlowFile cloned = session.create();
                cloned = session.putAllAttributes(cloned, originalAttributes);
                cloned = session.write(cloned, out -> out.write(queryPtr.getBytes()));
                session.transfer(cloned, REL_FAILURE);
            }
        }
    }

    private void handleFile(GridFSBucket bucket, ProcessSession session, ProcessContext context, FlowFile parent, GridFSFile input, String query) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(METADATA_ATTRIBUTE, input.getMetadata() != null ? input.getMetadata().toJson() : "{}");
        if (context.getProperty(QUERY_ATTRIBUTE).isSet()) {
            String key = context.getProperty(QUERY_ATTRIBUTE).evaluateAttributeExpressions(parent).getValue();
            attrs.put(key, query);
        }
        attrs.put(CoreAttributes.FILENAME.key(), input.getFilename());
        FlowFile output = parent != null ? session.create(parent) : session.create();
        output = session.write(output, out -> bucket.downloadToStream(input.getObjectId(), out));
        output = session.putAllAttributes(output, attrs);
        session.transfer(output, REL_SUCCESS);
        session.getProvenanceReporter().receive(output, this.getTransitUri(input.getObjectId(), output, context));
    }

    static {
        ArrayList<PropertyDescriptor> _temp = new ArrayList<PropertyDescriptor>();
        _temp.addAll(PARENT_PROPERTIES);
        _temp.add(FILE_NAME);
        _temp.add(QUERY);
        _temp.add(QUERY_ATTRIBUTE);
        _temp.add(OPERATION_MODE);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(_temp);
        HashSet<Relationship> _rels = new HashSet<Relationship>();
        _rels.addAll(PARENT_RELATIONSHIPS);
        _rels.add(REL_ORIGINAL);
        RELATIONSHIP_SET = Collections.unmodifiableSet(_rels);
    }
}

