/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.network.parser.util;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;

public final class ConversionUtil {
    public static final String toIPV4(byte[] buffer, int offset, int length) {
        try {
            return InetAddress.getByAddress(Arrays.copyOfRange(buffer, offset, offset + length)).getHostAddress();
        }
        catch (UnknownHostException e) {
            return String.valueOf(ConversionUtil.toInt(buffer, offset, length));
        }
    }

    public static final String toIPV6(byte[] buffer, int offset, int length) {
        try {
            return InetAddress.getByAddress(Arrays.copyOfRange(buffer, offset, offset + length)).getHostAddress();
        }
        catch (UnknownHostException e) {
            return String.valueOf(ConversionUtil.toLong(buffer, offset, length));
        }
    }

    public static final BigInteger toBigInteger(byte[] buffer, int offset, int length) {
        return new BigInteger(Arrays.copyOfRange(buffer, offset, offset + length));
    }

    public static final byte toByte(byte[] buffer, int offset) {
        return (byte)(buffer[offset] & 0xFF);
    }

    public static final int toInt(byte[] buffer, int offset, int length) {
        int ret = 0;
        int done = offset + length;
        for (int i = offset; i < done; ++i) {
            ret = (ret << 8 & 0xFFFFFFFF) + (buffer[i] & 0xFF);
        }
        return ret;
    }

    public static final long toLong(byte[] buffer, int offset, int length) {
        long ret = 0L;
        int done = offset + length;
        for (int i = offset; i < done; ++i) {
            ret <<= 8;
            ret |= (long)(buffer[i] & 0xFF);
        }
        return ret;
    }

    public static final short toShort(byte[] buffer, int offset, int length) {
        short ret = 0;
        int done = offset + length;
        for (int i = offset; i < done; ++i) {
            ret = (short)((ret << 8 & 0xFFFF) + (buffer[i] & 0xFF));
        }
        return ret;
    }

    public static final String toString(byte[] buffer, int offset, int length) {
        return new String(Arrays.copyOfRange(buffer, offset, offset + length));
    }

    public static byte[] toByteArray(int i) {
        byte[] result = new byte[]{(byte)(i >> 8), (byte)i};
        return result;
    }
}

