/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.parquet.record;

import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.processors.hadoop.record.HDFSRecordReader;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.parquet.hadoop.ParquetReader;

public class AvroParquetHDFSRecordReader
implements HDFSRecordReader {
    private GenericRecord lastRecord;
    private RecordSchema recordSchema;
    private boolean initialized = false;
    private final ParquetReader<GenericRecord> parquetReader;

    public AvroParquetHDFSRecordReader(ParquetReader<GenericRecord> parquetReader) {
        this.parquetReader = parquetReader;
    }

    public Record nextRecord() throws IOException {
        if (this.initialized && this.lastRecord == null) {
            return null;
        }
        this.lastRecord = (GenericRecord)this.parquetReader.read();
        this.initialized = true;
        if (this.lastRecord == null) {
            return null;
        }
        if (this.recordSchema == null) {
            this.recordSchema = AvroTypeUtil.createSchema((Schema)this.lastRecord.getSchema());
        }
        Map values = AvroTypeUtil.convertAvroRecordToMap((GenericRecord)this.lastRecord, (RecordSchema)this.recordSchema);
        return new MapRecord(this.recordSchema, values);
    }

    public void close() throws IOException {
        this.parquetReader.close();
    }
}

