/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.nifi.provenance.EncryptionException;
import org.apache.nifi.provenance.EventIdFirstSchemaRecordReader;
import org.apache.nifi.provenance.ProvenanceEventEncryptor;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.schema.LookupTableEventRecord;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedSchemaRecordReader
extends EventIdFirstSchemaRecordReader {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedSchemaRecordReader.class);
    private ProvenanceEventEncryptor provenanceEventEncryptor;
    public static final int SERIALIZATION_VERSION = 1;
    public static final String SERIALIZATION_NAME = "EncryptedSchemaRecordWriter";

    public EncryptedSchemaRecordReader(InputStream inputStream, String filename, TocReader tocReader, int maxAttributeChars, ProvenanceEventEncryptor provenanceEventEncryptor) throws IOException {
        super(inputStream, filename, tocReader, maxAttributeChars);
        this.provenanceEventEncryptor = provenanceEventEncryptor;
    }

    @Override
    protected StandardProvenanceEventRecord nextRecord(DataInputStream in, int serializationVersion) throws IOException {
        this.verifySerializationVersion(serializationVersion);
        long byteOffset = this.getBytesConsumed();
        long eventId = (long)in.readInt() + this.getFirstEventId();
        int recordLength = in.readInt();
        return this.readRecord(in, eventId, byteOffset, recordLength);
    }

    private StandardProvenanceEventRecord readRecord(DataInputStream inputStream, long eventId, long startOffset, int recordLength) throws IOException {
        try {
            LimitingInputStream limitedIn = new LimitingInputStream((InputStream)inputStream, (long)recordLength);
            byte[] encryptedSerializedBytes = new byte[recordLength];
            DataInputStream encryptedInputStream = new DataInputStream((InputStream)limitedIn);
            encryptedInputStream.readFully(encryptedSerializedBytes);
            byte[] plainSerializedBytes = this.decrypt(encryptedSerializedBytes, Long.toString(eventId));
            ByteArrayInputStream plainStream = new ByteArrayInputStream(plainSerializedBytes);
            Record eventRecord = this.getRecordReader().readRecord((InputStream)plainStream);
            if (eventRecord == null) {
                return null;
            }
            StandardProvenanceEventRecord deserializedEvent = LookupTableEventRecord.getEvent(eventRecord, this.getFilename(), startOffset, this.getMaxAttributeLength(), this.getFirstEventId(), this.getSystemTimeOffset(), this.getComponentIds(), this.getComponentTypes(), this.getQueueIds(), this.getEventTypes());
            deserializedEvent.setEventId(eventId);
            return deserializedEvent;
        }
        catch (EncryptionException e) {
            logger.error("Encountered an error reading the record: ", (Throwable)e);
            throw new IOException(e);
        }
    }

    @Override
    protected Optional<StandardProvenanceEventRecord> readToEvent(long eventId, DataInputStream dis, int serializationVersion) throws IOException {
        this.verifySerializationVersion(serializationVersion);
        while (this.isData(dis)) {
            long startOffset = this.getBytesConsumed();
            long id = (long)dis.readInt() + this.getFirstEventId();
            int recordLength = dis.readInt();
            if (id >= eventId) {
                StandardProvenanceEventRecord event = this.readRecord(dis, id, startOffset, recordLength);
                return Optional.ofNullable(event);
            }
            StreamUtils.skip((InputStream)dis, (long)recordLength);
        }
        return Optional.empty();
    }

    private byte[] decrypt(byte[] encryptedBytes, String eventId) throws IOException, EncryptionException {
        try {
            return this.provenanceEventEncryptor.decrypt(encryptedBytes, eventId);
        }
        catch (Exception e) {
            logger.error("Encountered an error: ", (Throwable)e);
            throw new EncryptionException((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    private String getDescription() {
        try {
            return "EncryptedSchemaRecordReader, toc: " + this.getTocReader().getFile().getAbsolutePath() + ", journal: " + this.getFilename();
        }
        catch (Exception e) {
            return "EncryptedSchemaRecordReader@" + Integer.toHexString(this.hashCode());
        }
    }

    void setProvenanceEventEncryptor(ProvenanceEventEncryptor provenanceEventEncryptor) {
        this.provenanceEventEncryptor = provenanceEventEncryptor;
    }
}

