/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.EncryptionException;
import org.apache.nifi.provenance.EventIdFirstSchemaRecordWriter;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceEventEncryptor;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.util.timebuffer.EntityAccess;
import org.apache.nifi.util.timebuffer.LongEntityAccess;
import org.apache.nifi.util.timebuffer.TimedBuffer;
import org.apache.nifi.util.timebuffer.TimestampedLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedSchemaRecordWriter
extends EventIdFirstSchemaRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedSchemaRecordWriter.class);
    private static final int DEFAULT_DEBUG_FREQUENCY = 1000000;
    private ProvenanceEventEncryptor provenanceEventEncryptor;
    private static final TimedBuffer<TimestampedLong> encryptTimes = new TimedBuffer(TimeUnit.SECONDS, 60, (EntityAccess)new LongEntityAccess());
    private String keyId;
    private int debugFrequency;
    public static final int SERIALIZATION_VERSION = 1;
    public static final String SERIALIZATION_NAME = "EncryptedSchemaRecordWriter";

    public EncryptedSchemaRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize, IdentifierLookup idLookup, ProvenanceEventEncryptor provenanceEventEncryptor) throws IOException, EncryptionException {
        this(file, idGenerator, writer, compressed, uncompressedBlockSize, idLookup, provenanceEventEncryptor, 1000000);
    }

    public EncryptedSchemaRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize, IdentifierLookup idLookup, ProvenanceEventEncryptor provenanceEventEncryptor, int debugFrequency) throws IOException, EncryptionException {
        super(file, idGenerator, writer, compressed, uncompressedBlockSize, idLookup);
        this.provenanceEventEncryptor = provenanceEventEncryptor;
        this.debugFrequency = debugFrequency;
        try {
            this.keyId = this.getNextAvailableKeyId();
        }
        catch (KeyManagementException e) {
            logger.error("Encountered an error initializing the encrypted schema record writer because the provided encryptor has no valid keys available: ", (Throwable)e);
            throw new EncryptionException("No valid keys in the provenance event encryptor", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageSummary writeRecord(ProvenanceEventRecord record) throws IOException {
        long endBytes;
        long startBytes;
        long recordIdentifier;
        long writeStart;
        byte[] cipherBytes;
        long encryptStart = System.nanoTime();
        try {
            byte[] serialized;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
                 DataOutputStream dos = new DataOutputStream(baos);){
                this.writeRecord(record, 0L, dos);
                serialized = baos.toByteArray();
            }
            String eventId = record.getBestEventIdentifier();
            cipherBytes = this.encrypt(serialized, eventId);
        }
        catch (EncryptionException e) {
            logger.error("Encountered an error: ", (Throwable)e);
            throw new IOException("Error encrypting the provenance record", e);
        }
        long encryptStop = System.nanoTime();
        long lockStart = System.nanoTime();
        EncryptedSchemaRecordWriter encryptedSchemaRecordWriter = this;
        synchronized (encryptedSchemaRecordWriter) {
            writeStart = System.nanoTime();
            try {
                recordIdentifier = record.getEventId() == -1L ? this.getIdGenerator().getAndIncrement() : record.getEventId();
                startBytes = this.getBytesWritten();
                this.ensureStreamState(recordIdentifier, startBytes);
                DataOutputStream out = this.getBufferedOutputStream();
                int recordIdOffset = (int)(recordIdentifier - this.getFirstEventId());
                out.writeInt(recordIdOffset);
                out.writeInt(cipherBytes.length);
                out.write(cipherBytes);
                this.getRecordCount().incrementAndGet();
                endBytes = this.getBytesWritten();
            }
            catch (IOException ioe) {
                this.markDirty();
                throw ioe;
            }
        }
        if (logger.isDebugEnabled()) {
            long writeNanos = System.nanoTime() - writeStart;
            EncryptedSchemaRecordWriter.getWriteTimes().add((Object)new TimestampedLong(Long.valueOf(writeNanos)));
            long serializeNanos = lockStart - encryptStart;
            EncryptedSchemaRecordWriter.getSerializeTimes().add((Object)new TimestampedLong(Long.valueOf(serializeNanos)));
            long encryptNanos = encryptStop - encryptStart;
            EncryptedSchemaRecordWriter.getEncryptTimes().add((Object)new TimestampedLong(Long.valueOf(encryptNanos)));
            long lockNanos = writeStart - lockStart;
            EncryptedSchemaRecordWriter.getLockTimes().add((Object)new TimestampedLong(Long.valueOf(lockNanos)));
            EncryptedSchemaRecordWriter.getBytesWrittenBuffer().add((Object)new TimestampedLong(Long.valueOf(endBytes - startBytes)));
            long recordCount = EncryptedSchemaRecordWriter.getTotalRecordCount().incrementAndGet();
            if (recordCount % (long)this.debugFrequency == 0L) {
                this.printStats();
            }
        }
        long serializedLength = endBytes - startBytes;
        TocWriter tocWriter = this.getTocWriter();
        Integer blockIndex = tocWriter == null ? null : Integer.valueOf(tocWriter.getCurrentBlockIndex());
        File file = this.getFile();
        String storageLocation = file.getParentFile().getName() + "/" + file.getName();
        return new StorageSummary(recordIdentifier, storageLocation, blockIndex, serializedLength, endBytes);
    }

    private void printStats() {
        long sixtySecondsAgo = System.currentTimeMillis() - 60000L;
        Long writeNanosLast60 = ((TimestampedLong)EncryptedSchemaRecordWriter.getWriteTimes().getAggregateValue(sixtySecondsAgo)).getValue();
        Long lockNanosLast60 = ((TimestampedLong)EncryptedSchemaRecordWriter.getLockTimes().getAggregateValue(sixtySecondsAgo)).getValue();
        Long serializeNanosLast60 = ((TimestampedLong)EncryptedSchemaRecordWriter.getSerializeTimes().getAggregateValue(sixtySecondsAgo)).getValue();
        Long encryptNanosLast60 = ((TimestampedLong)EncryptedSchemaRecordWriter.getEncryptTimes().getAggregateValue(sixtySecondsAgo)).getValue();
        Long bytesWrittenLast60 = ((TimestampedLong)EncryptedSchemaRecordWriter.getBytesWrittenBuffer().getAggregateValue(sixtySecondsAgo)).getValue();
        logger.debug("In the last 60 seconds, have spent {} millis writing to file ({} MB), {} millis waiting on synchronize block, {} millis serializing events, {} millis encrypting events", new Object[]{TimeUnit.NANOSECONDS.toMillis(writeNanosLast60), bytesWrittenLast60 / 1024L / 1024L, TimeUnit.NANOSECONDS.toMillis(lockNanosLast60), TimeUnit.NANOSECONDS.toMillis(serializeNanosLast60), TimeUnit.NANOSECONDS.toMillis(encryptNanosLast60)});
    }

    static TimedBuffer<TimestampedLong> getEncryptTimes() {
        return encryptTimes;
    }

    private byte[] encrypt(byte[] serialized, String eventId) throws IOException, EncryptionException {
        String keyId = this.getKeyId();
        try {
            return this.provenanceEventEncryptor.encrypt(serialized, eventId, keyId);
        }
        catch (Exception e) {
            logger.error("Encountered an error: ", (Throwable)e);
            throw new EncryptionException((Throwable)e);
        }
    }

    private String getNextAvailableKeyId() throws KeyManagementException {
        return this.provenanceEventEncryptor.getNextKeyId();
    }

    @Override
    protected int getSerializationVersion() {
        return 1;
    }

    @Override
    protected String getSerializationName() {
        return SERIALIZATION_NAME;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String toString() {
        return "EncryptedSchemaRecordWriter using " + this.provenanceEventEncryptor + " and current keyId " + this.keyId;
    }
}

