/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.properties.NiFiPropertiesLoader;
import org.apache.nifi.provenance.AESProvenanceEventEncryptor;
import org.apache.nifi.provenance.EncryptedSchemaRecordReader;
import org.apache.nifi.provenance.EncryptedSchemaRecordWriter;
import org.apache.nifi.provenance.EncryptionException;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventEncryptor;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.WriteAheadProvenanceRepository;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.apache.nifi.provenance.serialization.RecordWriter;
import org.apache.nifi.provenance.store.EventFileManager;
import org.apache.nifi.provenance.store.RecordReaderFactory;
import org.apache.nifi.provenance.store.RecordWriterFactory;
import org.apache.nifi.provenance.toc.StandardTocWriter;
import org.apache.nifi.provenance.toc.TocUtil;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.security.kms.KeyProviderFactory;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedWriteAheadProvenanceRepository
extends WriteAheadProvenanceRepository {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedWriteAheadProvenanceRepository.class);

    public EncryptedWriteAheadProvenanceRepository() {
    }

    public EncryptedWriteAheadProvenanceRepository(NiFiProperties nifiProperties) {
        super(RepositoryConfiguration.create(nifiProperties));
    }

    public EncryptedWriteAheadProvenanceRepository(RepositoryConfiguration config) {
        super(config);
    }

    @Override
    public synchronized void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
        AESProvenanceEventEncryptor provenanceEventEncryptor;
        if (this.getConfig().supportsEncryption()) {
            try {
                KeyProvider keyProvider;
                if (KeyProviderFactory.requiresMasterKey((String)this.getConfig().getKeyProviderImplementation())) {
                    SecretKey masterKey = EncryptedWriteAheadProvenanceRepository.getMasterKey();
                    keyProvider = this.buildKeyProvider(masterKey);
                } else {
                    keyProvider = this.buildKeyProvider();
                }
                provenanceEventEncryptor = new AESProvenanceEventEncryptor();
                provenanceEventEncryptor.initialize(keyProvider);
            }
            catch (KeyManagementException e) {
                String msg = "Encountered an error building the key provider";
                logger.error(msg, (Throwable)e);
                throw new IOException(msg, e);
            }
        } else {
            throw new IOException("The provided configuration does not support a encrypted repository");
        }
        RecordWriterFactory recordWriterFactory = (arg_0, arg_1, arg_2, arg_3) -> this.lambda$initialize$0(idLookup, (ProvenanceEventEncryptor)provenanceEventEncryptor, arg_0, arg_1, arg_2, arg_3);
        EventFileManager fileManager = new EventFileManager();
        RecordReaderFactory recordReaderFactory = (arg_0, arg_1, arg_2) -> EncryptedWriteAheadProvenanceRepository.lambda$initialize$1(fileManager, (ProvenanceEventEncryptor)provenanceEventEncryptor, arg_0, arg_1, arg_2);
        super.init(recordWriterFactory, recordReaderFactory, eventReporter, authorizer, resourceFactory);
    }

    private KeyProvider buildKeyProvider() throws KeyManagementException {
        return this.buildKeyProvider(null);
    }

    private KeyProvider buildKeyProvider(SecretKey masterKey) throws KeyManagementException {
        RepositoryConfiguration config = super.getConfig();
        if (config == null) {
            throw new KeyManagementException("The repository configuration is missing");
        }
        String implementationClassName = config.getKeyProviderImplementation();
        if (implementationClassName == null) {
            throw new KeyManagementException("Cannot create Key Provider because the NiFi Properties is missing the following property: nifi.provenance.repository.encryption.key.provider.implementation");
        }
        return KeyProviderFactory.buildKeyProvider((String)implementationClassName, (String)config.getKeyProviderLocation(), (String)config.getKeyId(), config.getEncryptionKeys(), (SecretKey)masterKey);
    }

    private static SecretKey getMasterKey() throws KeyManagementException {
        try {
            String masterKeyHex = NiFiPropertiesLoader.extractKeyFromBootstrapFile();
            return new SecretKeySpec(Hex.decodeHex((char[])masterKeyHex.toCharArray()), "AES");
        }
        catch (IOException | DecoderException e) {
            logger.error("Encountered an error: ", e);
            throw new KeyManagementException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ RecordReader lambda$initialize$1(EventFileManager fileManager, ProvenanceEventEncryptor provenanceEventEncryptor, File file, Collection logs, int maxChars) throws IOException {
        fileManager.obtainReadLock(file);
        try {
            EncryptedSchemaRecordReader tempReader = (EncryptedSchemaRecordReader)RecordReaders.newRecordReader(file, logs, maxChars);
            tempReader.setProvenanceEventEncryptor(provenanceEventEncryptor);
            EncryptedSchemaRecordReader encryptedSchemaRecordReader = tempReader;
            return encryptedSchemaRecordReader;
        }
        finally {
            fileManager.releaseReadLock(file);
        }
    }

    private /* synthetic */ RecordWriter lambda$initialize$0(IdentifierLookup idLookup, ProvenanceEventEncryptor provenanceEventEncryptor, File file, AtomicLong idGenerator, boolean compressed, boolean createToc) throws IOException {
        try {
            StandardTocWriter tocWriter = createToc ? new StandardTocWriter(TocUtil.getTocFile(file), false, false) : null;
            return new EncryptedSchemaRecordWriter(file, idGenerator, tocWriter, compressed, 32768, idLookup, provenanceEventEncryptor, this.getConfig().getDebugFrequency());
        }
        catch (EncryptionException e) {
            logger.error("Encountered an error building the schema record writer factory: ", (Throwable)e);
            throw new IOException(e);
        }
    }
}

