/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.schema.EventIdFirstHeaderSchema;
import org.apache.nifi.provenance.schema.LookupTableEventRecord;
import org.apache.nifi.provenance.schema.LookupTableEventSchema;
import org.apache.nifi.provenance.serialization.CompressableRecordWriter;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.provenance.util.ByteArrayDataOutputStream;
import org.apache.nifi.provenance.util.ByteArrayDataOutputStreamCache;
import org.apache.nifi.repository.schema.FieldMapRecord;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.SchemaRecordWriter;
import org.apache.nifi.util.timebuffer.EntityAccess;
import org.apache.nifi.util.timebuffer.LongEntityAccess;
import org.apache.nifi.util.timebuffer.TimedBuffer;
import org.apache.nifi.util.timebuffer.TimestampedLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventIdFirstSchemaRecordWriter
extends CompressableRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(EventIdFirstSchemaRecordWriter.class);
    private static final RecordSchema eventSchema = LookupTableEventSchema.EVENT_SCHEMA;
    private static final RecordSchema contentClaimSchema = new RecordSchema(eventSchema.getField("Content Claim").getSubFields());
    private static final RecordSchema previousContentClaimSchema = new RecordSchema(eventSchema.getField("Previous Content Claim").getSubFields());
    private static final RecordSchema headerSchema = EventIdFirstHeaderSchema.SCHEMA;
    public static final int SERIALIZATION_VERSION = 1;
    public static final String SERIALIZATION_NAME = "EventIdFirstSchemaRecordWriter";
    private final IdentifierLookup idLookup;
    private final SchemaRecordWriter schemaRecordWriter = new SchemaRecordWriter();
    private final AtomicInteger recordCount = new AtomicInteger(0);
    private final Map<String, Integer> componentIdMap;
    private final Map<String, Integer> componentTypeMap;
    private final Map<String, Integer> queueIdMap;
    private static final Map<String, Integer> eventTypeMap;
    private static final List<String> eventTypeNames;
    private static final TimedBuffer<TimestampedLong> serializeTimes;
    private static final TimedBuffer<TimestampedLong> lockTimes;
    private static final TimedBuffer<TimestampedLong> writeTimes;
    private static final TimedBuffer<TimestampedLong> bytesWritten;
    private static final AtomicLong totalRecordCount;
    private static final ByteArrayDataOutputStreamCache streamCache;
    private long firstEventId;
    private long systemTimeOffset;

    public EventIdFirstSchemaRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize, IdentifierLookup idLookup) throws IOException {
        super(file, idGenerator, writer, compressed, uncompressedBlockSize);
        this.idLookup = idLookup;
        this.componentIdMap = idLookup.invertComponentIdentifiers();
        this.componentTypeMap = idLookup.invertComponentTypes();
        this.queueIdMap = idLookup.invertQueueIdentifiers();
    }

    public EventIdFirstSchemaRecordWriter(OutputStream out, String storageLocation, AtomicLong idGenerator, TocWriter tocWriter, boolean compressed, int uncompressedBlockSize, IdentifierLookup idLookup) throws IOException {
        super(out, storageLocation, idGenerator, tocWriter, compressed, uncompressedBlockSize);
        this.idLookup = idLookup;
        this.componentIdMap = idLookup.invertComponentIdentifiers();
        this.componentTypeMap = idLookup.invertComponentTypes();
        this.queueIdMap = idLookup.invertQueueIdentifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageSummary writeRecord(ProvenanceEventRecord record) throws IOException {
        long endBytes;
        long startBytes;
        long recordIdentifier;
        long writeStart;
        long lockStart;
        if (this.isDirty()) {
            throw new IOException("Cannot update Provenance Repository because this Record Writer has already failed to write to the Repository");
        }
        long serializeStart = System.nanoTime();
        ByteArrayDataOutputStream bados = streamCache.checkOut();
        try {
            this.writeRecord(record, 0L, bados.getDataOutputStream());
            lockStart = System.nanoTime();
            EventIdFirstSchemaRecordWriter eventIdFirstSchemaRecordWriter = this;
            synchronized (eventIdFirstSchemaRecordWriter) {
                writeStart = System.nanoTime();
                try {
                    recordIdentifier = record.getEventId() == -1L ? this.getIdGenerator().getAndIncrement() : record.getEventId();
                    startBytes = this.getBytesWritten();
                    this.ensureStreamState(recordIdentifier, startBytes);
                    DataOutputStream out = this.getBufferedOutputStream();
                    int recordIdOffset = (int)(recordIdentifier - this.firstEventId);
                    out.writeInt(recordIdOffset);
                    ByteArrayOutputStream baos = bados.getByteArrayOutputStream();
                    out.writeInt(baos.size());
                    baos.writeTo(out);
                    this.recordCount.incrementAndGet();
                    endBytes = this.getBytesWritten();
                }
                catch (IOException ioe) {
                    this.markDirty();
                    throw ioe;
                }
            }
        }
        finally {
            streamCache.checkIn(bados);
        }
        if (logger.isDebugEnabled()) {
            long writeNanos = System.nanoTime() - writeStart;
            writeTimes.add((Object)new TimestampedLong(Long.valueOf(writeNanos)));
            long serializeNanos = lockStart - serializeStart;
            serializeTimes.add((Object)new TimestampedLong(Long.valueOf(serializeNanos)));
            long lockNanos = writeStart - lockStart;
            lockTimes.add((Object)new TimestampedLong(Long.valueOf(lockNanos)));
            bytesWritten.add((Object)new TimestampedLong(Long.valueOf(endBytes - startBytes)));
            long recordCount = totalRecordCount.incrementAndGet();
            if (recordCount % 1000000L == 0L) {
                long sixtySecondsAgo = System.currentTimeMillis() - 60000L;
                Long writeNanosLast60 = ((TimestampedLong)writeTimes.getAggregateValue(sixtySecondsAgo)).getValue();
                Long lockNanosLast60 = ((TimestampedLong)lockTimes.getAggregateValue(sixtySecondsAgo)).getValue();
                Long serializeNanosLast60 = ((TimestampedLong)serializeTimes.getAggregateValue(sixtySecondsAgo)).getValue();
                Long bytesWrittenLast60 = ((TimestampedLong)bytesWritten.getAggregateValue(sixtySecondsAgo)).getValue();
                logger.debug("In the last 60 seconds, have spent {} millis writing to file ({} MB), {} millis waiting on synchronize block, {} millis serializing events", new Object[]{TimeUnit.NANOSECONDS.toMillis(writeNanosLast60), bytesWrittenLast60 / 1024L / 1024L, TimeUnit.NANOSECONDS.toMillis(lockNanosLast60), TimeUnit.NANOSECONDS.toMillis(serializeNanosLast60)});
            }
        }
        long serializedLength = endBytes - startBytes;
        TocWriter tocWriter = this.getTocWriter();
        Integer blockIndex = tocWriter == null ? null : Integer.valueOf(tocWriter.getCurrentBlockIndex());
        File file = this.getFile();
        String storageLocation = file.getParentFile().getName() + "/" + file.getName();
        return new StorageSummary(recordIdentifier, storageLocation, blockIndex, serializedLength, endBytes);
    }

    @Override
    public int getRecordsWritten() {
        return this.recordCount.get();
    }

    protected Record createRecord(ProvenanceEventRecord event, long eventId) {
        return new LookupTableEventRecord(event, eventId, eventSchema, contentClaimSchema, previousContentClaimSchema, this.firstEventId, this.systemTimeOffset, this.componentIdMap, this.componentTypeMap, this.queueIdMap, eventTypeMap);
    }

    @Override
    protected void writeRecord(ProvenanceEventRecord event, long eventId, DataOutputStream out) throws IOException {
        Record eventRecord = this.createRecord(event, eventId);
        this.schemaRecordWriter.writeRecord(eventRecord, (OutputStream)out);
    }

    @Override
    protected synchronized void writeHeader(long firstEventId, DataOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        eventSchema.writeTo((OutputStream)baos);
        out.writeInt(baos.size());
        baos.writeTo(out);
        baos.reset();
        headerSchema.writeTo((OutputStream)baos);
        out.writeInt(baos.size());
        baos.writeTo(out);
        this.firstEventId = firstEventId;
        this.systemTimeOffset = System.currentTimeMillis();
        HashMap<String, Object> headerValues = new HashMap<String, Object>();
        headerValues.put("First Event ID", firstEventId);
        headerValues.put("Timestamp Offset", this.systemTimeOffset);
        headerValues.put("Component Identifiers", this.idLookup.getComponentIdentifiers());
        headerValues.put("Component Types", this.idLookup.getComponentTypes());
        headerValues.put("Queue Identifiers", this.idLookup.getQueueIdentifiers());
        headerValues.put("Event Types", eventTypeNames);
        FieldMapRecord headerInfo = new FieldMapRecord(headerSchema, headerValues);
        this.schemaRecordWriter.writeRecord((Record)headerInfo, (OutputStream)out);
    }

    @Override
    protected int getSerializationVersion() {
        return 1;
    }

    @Override
    protected String getSerializationName() {
        return SERIALIZATION_NAME;
    }

    IdentifierLookup getIdLookup() {
        return this.idLookup;
    }

    SchemaRecordWriter getSchemaRecordWriter() {
        return this.schemaRecordWriter;
    }

    AtomicInteger getRecordCount() {
        return this.recordCount;
    }

    static TimedBuffer<TimestampedLong> getSerializeTimes() {
        return serializeTimes;
    }

    static TimedBuffer<TimestampedLong> getLockTimes() {
        return lockTimes;
    }

    static TimedBuffer<TimestampedLong> getWriteTimes() {
        return writeTimes;
    }

    static TimedBuffer<TimestampedLong> getBytesWrittenBuffer() {
        return bytesWritten;
    }

    static AtomicLong getTotalRecordCount() {
        return totalRecordCount;
    }

    long getFirstEventId() {
        return this.firstEventId;
    }

    long getSystemTimeOffset() {
        return this.systemTimeOffset;
    }

    static {
        serializeTimes = new TimedBuffer(TimeUnit.SECONDS, 60, (EntityAccess)new LongEntityAccess());
        lockTimes = new TimedBuffer(TimeUnit.SECONDS, 60, (EntityAccess)new LongEntityAccess());
        writeTimes = new TimedBuffer(TimeUnit.SECONDS, 60, (EntityAccess)new LongEntityAccess());
        bytesWritten = new TimedBuffer(TimeUnit.SECONDS, 60, (EntityAccess)new LongEntityAccess());
        totalRecordCount = new AtomicLong(0L);
        streamCache = new ByteArrayDataOutputStreamCache(32, 8192, 262144);
        eventTypeMap = new HashMap<String, Integer>();
        eventTypeNames = new ArrayList<String>();
        int count = 0;
        for (ProvenanceEventType eventType : ProvenanceEventType.values()) {
            eventTypeMap.put(eventType.name(), count++);
            eventTypeNames.add(eventType.name());
        }
    }
}

