/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.provenance.EventIdFirstSchemaRecordWriter;
import org.apache.nifi.provenance.IdentifierLookup;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.authorization.UserEventAuthorizer;
import org.apache.nifi.provenance.index.EventIndex;
import org.apache.nifi.provenance.index.lucene.LuceneEventIndex;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lucene.SimpleIndexManager;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.QuerySubmission;
import org.apache.nifi.provenance.search.SearchableField;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.provenance.store.EventFileManager;
import org.apache.nifi.provenance.store.EventStore;
import org.apache.nifi.provenance.store.PartitionedWriteAheadEventStore;
import org.apache.nifi.provenance.store.RecordReaderFactory;
import org.apache.nifi.provenance.store.RecordWriterFactory;
import org.apache.nifi.provenance.store.StorageResult;
import org.apache.nifi.provenance.toc.StandardTocWriter;
import org.apache.nifi.provenance.toc.TocUtil;
import org.apache.nifi.provenance.util.CloseableUtil;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteAheadProvenanceRepository
implements ProvenanceRepository {
    private static final Logger logger = LoggerFactory.getLogger(WriteAheadProvenanceRepository.class);
    static final int BLOCK_SIZE = 32768;
    public static final String EVENT_CATEGORY = "Provenance Repository";
    private final RepositoryConfiguration config;
    private EventStore eventStore;
    private EventIndex eventIndex;
    private EventReporter eventReporter;
    private Authorizer authorizer;
    private ProvenanceAuthorizableFactory resourceFactory;

    public WriteAheadProvenanceRepository() {
        this.config = null;
    }

    public WriteAheadProvenanceRepository(NiFiProperties nifiProperties) {
        this(RepositoryConfiguration.create(nifiProperties));
    }

    public WriteAheadProvenanceRepository(RepositoryConfiguration config) {
        this.config = config;
    }

    public synchronized void initialize(EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory, IdentifierLookup idLookup) throws IOException {
        RecordWriterFactory recordWriterFactory = (file, idGenerator, compressed, createToc) -> {
            StandardTocWriter tocWriter = createToc ? new StandardTocWriter(TocUtil.getTocFile(file), false, false) : null;
            return new EventIdFirstSchemaRecordWriter(file, idGenerator, tocWriter, compressed, 32768, idLookup);
        };
        EventFileManager fileManager = new EventFileManager();
        RecordReaderFactory recordReaderFactory = (file, logs, maxChars) -> {
            fileManager.obtainReadLock(file);
            try {
                RecordReader recordReader = RecordReaders.newRecordReader(file, logs, maxChars);
                return recordReader;
            }
            finally {
                fileManager.releaseReadLock(file);
            }
        };
        this.init(recordWriterFactory, recordReaderFactory, eventReporter, authorizer, resourceFactory);
    }

    synchronized void init(RecordWriterFactory recordWriterFactory, RecordReaderFactory recordReaderFactory, EventReporter eventReporter, Authorizer authorizer, ProvenanceAuthorizableFactory resourceFactory) throws IOException {
        EventFileManager fileManager = new EventFileManager();
        this.eventStore = new PartitionedWriteAheadEventStore(this.config, recordWriterFactory, recordReaderFactory, eventReporter, fileManager);
        SimpleIndexManager indexManager = new SimpleIndexManager(this.config);
        this.eventIndex = new LuceneEventIndex(this.config, indexManager, eventReporter);
        this.eventReporter = eventReporter;
        this.authorizer = authorizer;
        this.resourceFactory = resourceFactory;
        this.eventStore.initialize();
        this.eventIndex.initialize(this.eventStore);
        try {
            this.eventStore.reindexLatestEvents(this.eventIndex);
        }
        catch (Exception e) {
            logger.error("Failed to re-index some of the Provenance Events. It is possible that some of the latest events will not be available from the Provenance Repository when a query is issued.", (Throwable)e);
        }
    }

    public ProvenanceEventBuilder eventBuilder() {
        return new StandardProvenanceEventRecord.Builder();
    }

    public void registerEvent(ProvenanceEventRecord event) {
        this.registerEvents(Collections.singleton(event));
    }

    public void registerEvents(Iterable<ProvenanceEventRecord> events) {
        StorageResult storageResult;
        try {
            storageResult = this.eventStore.addEvents(events);
        }
        catch (IOException e) {
            logger.error("Failed to write events to the Event Store", (Throwable)e);
            this.eventReporter.reportEvent(Severity.ERROR, EVENT_CATEGORY, "Failed to write Provenance Events to the repository. See logs for more details.");
            return;
        }
        Map<ProvenanceEventRecord, StorageSummary> locationMap = storageResult.getStorageLocations();
        if (!locationMap.isEmpty()) {
            this.eventIndex.addEvents(locationMap);
        }
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords) throws IOException {
        return this.eventStore.getEvents(firstRecordId, maxRecords);
    }

    public ProvenanceEventRecord getEvent(long id) throws IOException {
        return this.eventStore.getEvent(id).orElse(null);
    }

    public Long getMaxEventId() {
        return this.eventStore.getMaxEventId();
    }

    public void close() {
        CloseableUtil.closeQuietly(this.eventStore, this.eventIndex);
    }

    public ProvenanceEventRecord getEvent(long id, NiFiUser user) throws IOException {
        ProvenanceEventRecord event = this.getEvent(id);
        if (event == null) {
            return null;
        }
        this.authorize(event, user);
        return event;
    }

    private void authorize(ProvenanceEventRecord event, NiFiUser user) {
        if (this.authorizer == null || user == null) {
            return;
        }
        Authorizable eventAuthorizable = this.resourceFactory.createProvenanceDataAuthorizable(event.getComponentId());
        eventAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
    }

    public List<ProvenanceEventRecord> getEvents(long firstRecordId, int maxRecords, NiFiUser user) throws IOException {
        List<ProvenanceEventRecord> events = this.getEvents(firstRecordId, maxRecords);
        return this.createEventAuthorizer(user).filterUnauthorizedEvents(events);
    }

    private EventAuthorizer createEventAuthorizer(NiFiUser user) {
        return new UserEventAuthorizer(this.authorizer, this.resourceFactory, user);
    }

    public ProvenanceEventRepository getProvenanceEventRepository() {
        return this;
    }

    public QuerySubmission submitQuery(Query query, NiFiUser user) {
        return this.eventIndex.submitQuery(query, this.createEventAuthorizer(user), user == null ? null : user.getIdentity());
    }

    public QuerySubmission retrieveQuerySubmission(String queryIdentifier, NiFiUser user) {
        return this.eventIndex.retrieveQuerySubmission(queryIdentifier, user);
    }

    public ComputeLineageSubmission submitLineageComputation(String flowFileUuid, NiFiUser user) {
        return this.eventIndex.submitLineageComputation(flowFileUuid, user, this.createEventAuthorizer(user));
    }

    public ComputeLineageSubmission submitLineageComputation(long eventId, NiFiUser user) {
        return this.eventIndex.submitLineageComputation(eventId, user, this.createEventAuthorizer(user));
    }

    public ComputeLineageSubmission retrieveLineageSubmission(String lineageIdentifier, NiFiUser user) {
        return this.eventIndex.retrieveLineageSubmission(lineageIdentifier, user);
    }

    public ComputeLineageSubmission submitExpandParents(long eventId, NiFiUser user) {
        return this.eventIndex.submitExpandParents(eventId, user, this.createEventAuthorizer(user));
    }

    public ComputeLineageSubmission submitExpandChildren(long eventId, NiFiUser user) {
        return this.eventIndex.submitExpandChildren(eventId, user, this.createEventAuthorizer(user));
    }

    public List<SearchableField> getSearchableFields() {
        return Collections.unmodifiableList(this.config.getSearchableFields());
    }

    public List<SearchableField> getSearchableAttributes() {
        return Collections.unmodifiableList(this.config.getSearchableAttributes());
    }

    RepositoryConfiguration getConfig() {
        return this.config;
    }

    public Set<String> getContainerNames() {
        return new HashSet<String>(this.config.getStorageDirectories().keySet());
    }

    public long getContainerCapacity(String containerName) throws IOException {
        Map<String, File> map = this.config.getStorageDirectories();
        File container = map.get(containerName);
        if (container != null) {
            long capacity = FileUtils.getContainerCapacity((Path)container.toPath());
            if (capacity == 0L) {
                throw new IOException("System returned total space of the partition for " + containerName + " is zero byte. Nifi can not create a zero sized provenance repository.");
            }
            return capacity;
        }
        throw new IllegalArgumentException("There is no defined container with name " + containerName);
    }

    public String getContainerFileStoreName(String containerName) {
        Map<String, File> map = this.config.getStorageDirectories();
        File container = map.get(containerName);
        if (container == null) {
            return null;
        }
        try {
            return Files.getFileStore(container.toPath()).name();
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getContainerUsableSpace(String containerName) throws IOException {
        Map<String, File> map = this.config.getStorageDirectories();
        File container = map.get(containerName);
        if (container != null) {
            return FileUtils.getContainerUsableSpace((Path)container.toPath());
        }
        throw new IllegalArgumentException("There is no defined container with name " + containerName);
    }
}

