/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.index.EventIndexWriter;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.lucene.LuceneEventIndexSearcher;
import org.apache.nifi.provenance.lucene.LuceneEventIndexWriter;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingIndexManager
implements Closeable,
IndexManager {
    private static final Logger logger = LoggerFactory.getLogger(CachingIndexManager.class);
    private final Lock lock = new ReentrantLock();
    private final Map<File, IndexWriterCount> writerCounts = new HashMap<File, IndexWriterCount>();
    private final Map<File, List<ActiveIndexSearcher>> activeSearchers = new HashMap<File, List<ActiveIndexSearcher>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIndex(File indexDirectory) {
        block13: {
            File absoluteFile = indexDirectory.getAbsoluteFile();
            logger.info("Removing index {}", (Object)indexDirectory);
            this.lock.lock();
            try {
                List<ActiveIndexSearcher> searcherList;
                IndexWriterCount count = this.writerCounts.remove(absoluteFile);
                if (count != null) {
                    try {
                        count.close();
                    }
                    catch (IOException ioe) {
                        logger.warn("Failed to close Index Writer {} for {}", (Object)count.getWriter(), (Object)absoluteFile);
                        if (logger.isDebugEnabled()) {
                            logger.warn("", (Throwable)ioe);
                        }
                        boolean bl = false;
                        this.lock.unlock();
                        return bl;
                    }
                }
                if ((searcherList = this.activeSearchers.remove(absoluteFile)) == null) break block13;
                for (ActiveIndexSearcher searcher : searcherList) {
                    try {
                        searcher.close();
                    }
                    catch (IOException ioe) {
                        logger.warn("Failed to close Index Searcher {} for {} due to {}", new Object[]{searcher.getSearcher(), absoluteFile, ioe});
                        if (logger.isDebugEnabled()) {
                            logger.warn("", (Throwable)ioe);
                        }
                        boolean bl = false;
                        this.lock.unlock();
                        return bl;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventIndexWriter borrowIndexWriter(File indexDirectory) throws IOException {
        File absoluteFile = indexDirectory.getAbsoluteFile();
        logger.trace("Borrowing index writer for {}", (Object)indexDirectory);
        this.lock.lock();
        try {
            IndexWriterCount writerCount = this.writerCounts.remove(absoluteFile);
            if (writerCount == null) {
                ArrayList<Object> closeables = new ArrayList<Object>();
                FSDirectory directory = FSDirectory.open((File)indexDirectory);
                closeables.add(directory);
                try {
                    StandardAnalyzer analyzer = new StandardAnalyzer();
                    closeables.add(analyzer);
                    IndexWriterConfig config = new IndexWriterConfig(LuceneUtil.LUCENE_VERSION, (Analyzer)analyzer);
                    config.setWriteLockTimeout(300000L);
                    IndexWriter indexWriter = new IndexWriter((Directory)directory, config);
                    LuceneEventIndexWriter eventIndexWriter = new LuceneEventIndexWriter(indexWriter, indexDirectory);
                    writerCount = new IndexWriterCount(eventIndexWriter, (Analyzer)analyzer, (Directory)directory, 1);
                    logger.debug("Providing new index writer for {}", (Object)indexDirectory);
                }
                catch (IOException ioe) {
                    for (Closeable closeable : closeables) {
                        try {
                            closeable.close();
                        }
                        catch (IOException ioe2) {
                            ioe.addSuppressed(ioe2);
                        }
                    }
                    throw ioe;
                }
                this.writerCounts.put(absoluteFile, writerCount);
                List<ActiveIndexSearcher> searchers = this.activeSearchers.get(absoluteFile);
                if (searchers != null) {
                    for (ActiveIndexSearcher activeIndexSearcher : searchers) {
                        logger.debug("Poisoning {} because it is searching {}, which is getting updated", (Object)activeIndexSearcher, (Object)indexDirectory);
                        activeIndexSearcher.poison();
                    }
                }
            } else {
                logger.debug("Providing existing index writer for {} and incrementing count to {}", (Object)indexDirectory, (Object)(writerCount.getCount() + 1));
                this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), writerCount.getCount() + 1));
            }
            EventIndexWriter eventIndexWriter = writerCount.getWriter();
            return eventIndexWriter;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void returnIndexWriter(EventIndexWriter writer) {
        this.returnIndexWriter(writer, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexWriter(EventIndexWriter writer, boolean commit, boolean isCloseable) {
        block18: {
            File indexDirectory = writer.getDirectory();
            File absoluteFile = indexDirectory.getAbsoluteFile();
            logger.trace("Returning Index Writer for {} to IndexManager", (Object)indexDirectory);
            this.lock.lock();
            try {
                IndexWriterCount count = this.writerCounts.get(absoluteFile);
                try {
                    if (count == null) {
                        logger.warn("Index Writer {} was returned to IndexManager for {}, but this writer is not known. This could potentially lead to a resource leak", (Object)writer, (Object)indexDirectory);
                        writer.close();
                        break block18;
                    }
                    if (count.getCount() <= 1) {
                        logger.info("Decrementing count for Index Writer for {} to {}. Now finished writing to this Index Directory", (Object)indexDirectory, (Object)(count.getCount() - 1));
                        try {
                            if (commit) {
                                writer.commit();
                            }
                            break block18;
                        }
                        finally {
                            if (isCloseable) {
                                try {
                                    count.close();
                                }
                                finally {
                                    this.writerCounts.remove(absoluteFile);
                                }
                            }
                        }
                    }
                    logger.debug("Decrementing count for Index Writer for {} to {}", (Object)indexDirectory, (Object)(count.getCount() - 1));
                    this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1));
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close Index Writer {} due to {}", (Object)writer, (Object)ioe);
                    if (logger.isDebugEnabled()) {
                        logger.warn("", (Throwable)ioe);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventIndexSearcher borrowIndexSearcher(File indexDir) throws IOException {
        File absoluteFile = indexDir.getAbsoluteFile();
        logger.trace("Borrowing index searcher for {}", (Object)indexDir);
        this.lock.lock();
        List<ActiveIndexSearcher> currentlyCached = this.activeSearchers.get(absoluteFile);
        if (currentlyCached == null) {
            currentlyCached = new ArrayList<ActiveIndexSearcher>();
            this.activeSearchers.put(absoluteFile, currentlyCached);
        } else {
            for (ActiveIndexSearcher searcher : currentlyCached) {
                if (!searcher.isCache()) continue;
                if (searcher.isPoisoned()) continue;
                int refCount = searcher.getSearcher().getIndexSearcher().getIndexReader().getRefCount();
                if (refCount <= 0) {
                    logger.debug("Reference count for cached Index Searcher for {} is currently {}; removing cached searcher", (Object)absoluteFile, (Object)refCount);
                    continue;
                }
                int referenceCount = searcher.incrementReferenceCount();
                logger.debug("Providing previously cached index searcher for {} and incrementing Reference Count to {}", (Object)indexDir, (Object)referenceCount);
                EventIndexSearcher eventIndexSearcher = searcher.getSearcher();
                return eventIndexSearcher;
            }
        }
        IndexWriterCount writerCount = this.writerCounts.remove(absoluteFile);
        if (writerCount == null) {
            FSDirectory directory = FSDirectory.open((File)absoluteFile);
            logger.debug("No Index Writer currently exists for {}; creating a cachable reader", (Object)indexDir);
            try {
                DirectoryReader directoryReader = DirectoryReader.open((Directory)directory);
                IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader);
                LuceneEventIndexSearcher eventIndexSearcher = new LuceneEventIndexSearcher(searcher, indexDir, (Directory)directory, directoryReader);
                ActiveIndexSearcher cached = new ActiveIndexSearcher(eventIndexSearcher, absoluteFile, directoryReader, (Directory)directory, true);
                currentlyCached.add(cached);
                EventIndexSearcher eventIndexSearcher2 = cached.getSearcher();
                return eventIndexSearcher2;
            }
            catch (IOException e) {
                logger.error("Failed to create Index Searcher for {} due to {}", (Object)absoluteFile, (Object)e.toString());
                logger.error("", (Throwable)e);
                try {
                    directory.close();
                }
                catch (IOException ioe) {
                    e.addSuppressed(ioe);
                }
                throw e;
            }
        }
        logger.debug("Index Writer currently exists for {}; creating a non-cachable reader and incrementing counter to {}", (Object)indexDir, (Object)(writerCount.getCount() + 1));
        this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), writerCount.getCount() + 1));
        EventIndexWriter writer = writerCount.getWriter();
        DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)writer.getIndexWriter(), (boolean)false);
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader);
        LuceneEventIndexSearcher eventIndexSearcher = new LuceneEventIndexSearcher(searcher, indexDir, null, directoryReader);
        ActiveIndexSearcher activeSearcher = new ActiveIndexSearcher(eventIndexSearcher, absoluteFile, directoryReader, null, false);
        currentlyCached.add(activeSearcher);
        EventIndexSearcher eventIndexSearcher3 = activeSearcher.getSearcher();
        return eventIndexSearcher3;
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void returnIndexSearcher(EventIndexSearcher searcher) {
        File indexDirectory = searcher.getIndexDirectory();
        File absoluteFile = indexDirectory.getAbsoluteFile();
        logger.trace("Returning index searcher for {} to IndexManager", (Object)indexDirectory);
        this.lock.lock();
        try {
            List<ActiveIndexSearcher> currentlyCached = this.activeSearchers.get(absoluteFile);
            if (currentlyCached == null) {
                logger.warn("Received Index Searcher for {} but no searcher was provided for that directory; this could result in a resource leak", (Object)indexDirectory);
                return;
            }
            Iterator<ActiveIndexSearcher> itr = new ArrayList<ActiveIndexSearcher>(currentlyCached).iterator();
            boolean activeSearcherFound = false;
            while (itr.hasNext()) {
                ActiveIndexSearcher activeSearcher = itr.next();
                if (!activeSearcher.getSearcher().equals(searcher)) continue;
                activeSearcherFound = true;
                if (activeSearcher.isCache()) {
                    if (activeSearcher.isPoisoned()) {
                        itr.remove();
                        try {
                            activeSearcher.close();
                            return;
                        }
                        catch (IOException ioe) {
                            logger.warn("Failed to close Index Searcher for {} due to {}", (Object)absoluteFile, (Object)ioe);
                            if (!logger.isDebugEnabled()) return;
                            logger.warn("", (Throwable)ioe);
                        }
                        return;
                    }
                    int refCount = activeSearcher.decrementReferenceCount();
                    logger.debug("Index searcher for {} is cached; leaving open with reference count of {}", (Object)indexDirectory, (Object)refCount);
                    return;
                }
                itr.remove();
                IndexWriterCount writerCount = this.writerCounts.remove(absoluteFile);
                if (writerCount != null) {
                    if (writerCount.getCount() <= 1) {
                        try {
                            logger.debug("Index searcher for {} is not cached. Writer count is decremented to {}; closing writer", (Object)indexDirectory, (Object)(writerCount.getCount() - 1));
                            writerCount.close();
                        }
                        catch (IOException ioe) {
                            logger.warn("Failed to close Index Writer for {} due to {}", (Object)absoluteFile, (Object)ioe);
                            if (logger.isDebugEnabled()) {
                                logger.warn("", (Throwable)ioe);
                            }
                        }
                    } else {
                        logger.debug("Index searcher for {} is not cached. Writer count is decremented to {}; leaving writer open", (Object)indexDirectory, (Object)(writerCount.getCount() - 1));
                        this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), writerCount.getCount() - 1));
                    }
                }
                try {
                    logger.debug("Closing Index Searcher for {}", (Object)indexDirectory);
                    boolean allReferencesClosed = activeSearcher.close();
                    if (allReferencesClosed) continue;
                    currentlyCached.add(activeSearcher);
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close Index Searcher for {} due to {}", (Object)absoluteFile, (Object)ioe);
                    if (!logger.isDebugEnabled()) continue;
                    logger.warn("", (Throwable)ioe);
                }
            }
            if (activeSearcherFound) return;
            logger.debug("Index Searcher {} was returned for {} but found no Active Searcher for it. This will occur if the Index Searcher was already returned while being poisoned.", (Object)searcher, (Object)indexDirectory);
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        logger.debug("Closing Index Manager");
        this.lock.lock();
        try {
            IOException ioe = null;
            for (IndexWriterCount indexWriterCount : this.writerCounts.values()) {
                try {
                    indexWriterCount.close();
                }
                catch (IOException e) {
                    if (ioe == null) {
                        ioe = e;
                        continue;
                    }
                    ioe.addSuppressed(e);
                }
            }
            for (List list : this.activeSearchers.values()) {
                for (ActiveIndexSearcher searcher : list) {
                    try {
                        searcher.close();
                    }
                    catch (IOException e) {
                        if (ioe == null) {
                            ioe = e;
                            continue;
                        }
                        ioe.addSuppressed(e);
                    }
                }
            }
            if (ioe != null) {
                throw ioe;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void close(Closeable ... closeables) throws IOException {
        IOException ioe = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private static class IndexWriterCount
    implements Closeable {
        private final EventIndexWriter writer;
        private final Analyzer analyzer;
        private final Directory directory;
        private final int count;

        public IndexWriterCount(EventIndexWriter writer, Analyzer analyzer, Directory directory, int count) {
            this.writer = writer;
            this.analyzer = analyzer;
            this.directory = directory;
            this.count = count;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public EventIndexWriter getWriter() {
            return this.writer;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void close() throws IOException {
            CachingIndexManager.close(new Closeable[]{this.writer, this.analyzer, this.directory});
        }
    }

    private static class ActiveIndexSearcher {
        private final EventIndexSearcher searcher;
        private final DirectoryReader directoryReader;
        private final File indexDirectory;
        private final Directory directory;
        private final boolean cache;
        private final AtomicInteger referenceCount = new AtomicInteger(1);
        private volatile boolean poisoned = false;

        public ActiveIndexSearcher(EventIndexSearcher searcher, File indexDirectory, DirectoryReader directoryReader, Directory directory, boolean cache) {
            this.searcher = searcher;
            this.directoryReader = directoryReader;
            this.indexDirectory = indexDirectory;
            this.directory = directory;
            this.cache = cache;
        }

        public boolean isCache() {
            return this.cache;
        }

        public EventIndexSearcher getSearcher() {
            return this.searcher;
        }

        public boolean isPoisoned() {
            return this.poisoned;
        }

        public void poison() {
            this.poisoned = true;
        }

        public int incrementReferenceCount() {
            return this.referenceCount.incrementAndGet();
        }

        public int decrementReferenceCount() {
            return this.referenceCount.decrementAndGet();
        }

        public boolean close() throws IOException {
            int updatedRefCount = this.referenceCount.decrementAndGet();
            if (updatedRefCount <= 0) {
                logger.debug("Decremented Reference Count for {} to {}; closing underlying directory reader", (Object)this, (Object)updatedRefCount);
                CachingIndexManager.close(new Closeable[]{this.directoryReader, this.directory});
                return true;
            }
            logger.debug("Decremented Reference Count for {} to {}; leaving underlying directory reader open", (Object)this, (Object)updatedRefCount);
            return false;
        }

        public String toString() {
            return "ActiveIndexSearcher[directory=" + this.indexDirectory + ", cached=" + this.cache + ", poisoned=" + this.poisoned + "]";
        }
    }
}

