/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.nifi.provenance.IndexConfiguration;
import org.apache.nifi.provenance.PersistentProvenanceRepository;
import org.apache.nifi.provenance.expiration.ExpirationAction;
import org.apache.nifi.provenance.index.EventIndexWriter;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteIndexAction
implements ExpirationAction {
    private static final Logger logger = LoggerFactory.getLogger(DeleteIndexAction.class);
    private final PersistentProvenanceRepository repository;
    private final IndexConfiguration indexConfiguration;
    private final IndexManager indexManager;

    public DeleteIndexAction(PersistentProvenanceRepository repo, IndexConfiguration indexConfiguration, IndexManager indexManager) {
        this.repository = repo;
        this.indexConfiguration = indexConfiguration;
        this.indexManager = indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File execute(File expiredFile) throws IOException {
        long numDeleted = 0L;
        long maxEventId = -1L;
        try {
            RecordReader reader = RecordReaders.newRecordReader(expiredFile, this.repository.getAllLogFiles(), Integer.MAX_VALUE);
            Object object = null;
            try {
                maxEventId = reader.getMaxEventId();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            logger.warn("Failed to obtain max ID present in journal file {}", (Object)expiredFile.getAbsolutePath());
        }
        List<File> indexDirs = this.indexConfiguration.getIndexDirectories(expiredFile);
        for (File indexingDirectory : indexDirs) {
            Term term = new Term("storage-filename", LuceneUtil.substringBefore(expiredFile.getName(), "."));
            boolean deleteDir = false;
            EventIndexWriter writer = this.indexManager.borrowIndexWriter(indexingDirectory);
            try {
                IndexWriter indexWriter = writer.getIndexWriter();
                indexWriter.deleteDocuments(new Term[]{term});
                indexWriter.commit();
                int docsLeft = indexWriter.numDocs();
                deleteDir = docsLeft <= 0;
                logger.debug("After expiring {}, there are {} docs left for index {}", new Object[]{expiredFile, docsLeft, indexingDirectory});
            }
            finally {
                this.indexManager.returnIndexWriter(writer);
            }
            if (!deleteDir) continue;
            this.indexManager.removeIndex(indexingDirectory);
            this.indexConfiguration.removeIndexDirectory(indexingDirectory);
            this.deleteDirectory(indexingDirectory);
            logger.info("Removed empty index directory {}", (Object)indexingDirectory);
        }
        if (maxEventId > -1L) {
            this.indexConfiguration.setMinIdIndexed(maxEventId + 1L);
        }
        logger.info("Deleted Indices for Expired Provenance File {} from {} index files; {} documents removed", new Object[]{expiredFile, indexDirs.size(), 0L});
        return expiredFile;
    }

    private void deleteDirectory(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (child.isDirectory()) {
                this.deleteDirectory(child);
                continue;
            }
            if (child.delete()) continue;
            logger.warn("Unable to remove index directory {}; this directory should be cleaned up manually", (Object)child.getAbsolutePath());
        }
        if (!dir.delete()) {
            logger.warn("Unable to remove index directory {}; this directory should be cleaned up manually", (Object)dir);
        }
    }

    @Override
    public boolean hasBeenPerformed(File expiredFile) throws IOException {
        return false;
    }
}

