/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.TopDocs;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.provenance.PersistentProvenanceRepository;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.StandardQueryResult;
import org.apache.nifi.provenance.authorization.EventAuthorizer;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.lucene.DocsReader;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSearch {
    private final Logger logger = LoggerFactory.getLogger(IndexSearch.class);
    private final PersistentProvenanceRepository repository;
    private final File indexDirectory;
    private final IndexManager indexManager;
    private final int maxAttributeChars;

    public IndexSearch(PersistentProvenanceRepository repo, File indexDirectory, IndexManager indexManager, int maxAttributeChars) {
        this.repository = repo;
        this.indexDirectory = indexDirectory;
        this.indexManager = indexManager;
        this.maxAttributeChars = maxAttributeChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardQueryResult search(Query provenanceQuery, final NiFiUser user, AtomicInteger retrievedCount, long firstEventTimestamp) throws IOException {
        if (retrievedCount.get() >= provenanceQuery.getMaxResults()) {
            StandardQueryResult sqr = new StandardQueryResult(provenanceQuery, 1);
            sqr.update(Collections.emptyList(), 0L);
            this.logger.info("Skipping search of Provenance Index {} for {} because the max number of results ({}) has already been retrieved", new Object[]{this.indexDirectory, provenanceQuery, provenanceQuery.getMaxResults()});
            return sqr;
        }
        long startNanos = System.nanoTime();
        if (!this.indexDirectory.exists() && !this.indexDirectory.mkdirs()) {
            throw new IOException("Unable to create Indexing Directory " + this.indexDirectory);
        }
        if (!this.indexDirectory.isDirectory()) {
            throw new IOException("Indexing Directory specified is " + this.indexDirectory + ", but this is not a directory");
        }
        StandardQueryResult sqr = new StandardQueryResult(provenanceQuery, 1);
        if (provenanceQuery.getStartDate() == null || provenanceQuery.getStartDate().getTime() < firstEventTimestamp) {
            provenanceQuery.setStartDate(new Date(firstEventTimestamp));
        }
        if (provenanceQuery.getEndDate() == null) {
            provenanceQuery.setEndDate(new Date());
        }
        org.apache.lucene.search.Query luceneQuery = LuceneUtil.convertQuery(provenanceQuery);
        long start = System.nanoTime();
        EventIndexSearcher searcher = null;
        try {
            searcher = this.indexManager.borrowIndexSearcher(this.indexDirectory);
            long searchStartNanos = System.nanoTime();
            long openSearcherNanos = searchStartNanos - start;
            this.logger.debug("Searching {} for {}", (Object)this, (Object)provenanceQuery);
            TopDocs topDocs = searcher.getIndexSearcher().search(luceneQuery, provenanceQuery.getMaxResults());
            long finishSearch = System.nanoTime();
            long searchNanos = finishSearch - searchStartNanos;
            this.logger.debug("Searching {} for {} took {} millis; opening searcher took {} millis", new Object[]{this, provenanceQuery, TimeUnit.NANOSECONDS.toMillis(searchNanos), TimeUnit.NANOSECONDS.toMillis(openSearcherNanos)});
            if (topDocs.totalHits == 0) {
                sqr.update(Collections.emptyList(), 0L);
                StandardQueryResult standardQueryResult = sqr;
                return standardQueryResult;
            }
            DocsReader docsReader = new DocsReader();
            EventAuthorizer authorizer = new EventAuthorizer(){

                @Override
                public boolean isAuthorized(ProvenanceEventRecord event) {
                    return IndexSearch.this.repository.isAuthorized(event, user);
                }

                @Override
                public void authorize(ProvenanceEventRecord event) throws AccessDeniedException {
                    IndexSearch.this.repository.authorize(event, user);
                }

                @Override
                public List<ProvenanceEventRecord> filterUnauthorizedEvents(List<ProvenanceEventRecord> events) {
                    return IndexSearch.this.repository.filterUnauthorizedEvents(events, user);
                }

                @Override
                public Set<ProvenanceEventRecord> replaceUnauthorizedWithPlaceholders(Set<ProvenanceEventRecord> events) {
                    return IndexSearch.this.repository.replaceUnauthorizedWithPlaceholders(events, user);
                }
            };
            Set<ProvenanceEventRecord> matchingRecords = docsReader.read(topDocs, authorizer, searcher.getIndexSearcher().getIndexReader(), this.repository.getAllLogFiles(), retrievedCount, provenanceQuery.getMaxResults(), this.maxAttributeChars);
            long readRecordsNanos = System.nanoTime() - finishSearch;
            this.logger.debug("Reading {} records took {} millis for {}", new Object[]{matchingRecords.size(), TimeUnit.NANOSECONDS.toMillis(readRecordsNanos), this});
            sqr.update(matchingRecords, (long)topDocs.totalHits);
            long queryNanos = System.nanoTime() - startNanos;
            this.logger.info("Successfully executed {} against Index {}; Search took {} milliseconds; Total Hits = {}", new Object[]{provenanceQuery, this.indexDirectory, TimeUnit.NANOSECONDS.toMillis(queryNanos), topDocs.totalHits});
            StandardQueryResult standardQueryResult = sqr;
            return standardQueryResult;
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Attempted to search Provenance Index {} but could not find the file due to {}", (Object)this.indexDirectory, (Object)e);
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("", (Throwable)e);
            }
            sqr.update(Collections.emptyList(), 0L);
            StandardQueryResult standardQueryResult = sqr;
            return standardQueryResult;
        }
        finally {
            if (searcher != null) {
                this.indexManager.returnIndexSearcher(searcher);
            }
        }
    }

    public String toString() {
        return "IndexSearcher[" + this.indexDirectory + "]";
    }
}

