/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.Version;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.search.Query;
import org.apache.nifi.provenance.search.SearchTerm;

public class LuceneUtil {
    public static final Version LUCENE_VERSION = Version.LATEST;

    public static String substringBefore(String value, String searchValue) {
        int index = value.indexOf(searchValue);
        return index < 0 ? value : value.substring(0, index);
    }

    public static String substringAfter(String value, String searchValue) {
        int index = value.indexOf(searchValue);
        return index < 0 ? value : (index > value.length() - 2 ? "" : value.substring(index + 1));
    }

    public static String substringBeforeLast(String value, String searchValue) {
        int index = value.lastIndexOf(searchValue);
        return index < 0 ? value : value.substring(0, index);
    }

    public static String substringAfterLast(String value, String searchValue) {
        int index = value.lastIndexOf(searchValue);
        return index < 0 || index >= value.length() ? value : value.substring(index + 1);
    }

    public static File getProvenanceLogFile(String baseName, Collection<Path> allProvenanceLogs) {
        List<File> logFiles = LuceneUtil.getProvenanceLogFiles(baseName, allProvenanceLogs);
        if (logFiles.size() != 1) {
            return null;
        }
        return logFiles.get(0);
    }

    public static List<File> getProvenanceLogFiles(String baseName, Collection<Path> allProvenanceLogs) {
        ArrayList<File> matchingFiles = new ArrayList<File>();
        String searchString = baseName + ".";
        for (Path path : allProvenanceLogs) {
            if (!path.toFile().getName().startsWith(searchString)) continue;
            File file = path.toFile();
            if (file.exists()) {
                matchingFiles.add(file);
                continue;
            }
            File dir = file.getParentFile();
            File gzFile = new File(dir, file.getName() + ".gz");
            if (!gzFile.exists()) continue;
            matchingFiles.add(gzFile);
        }
        return matchingFiles;
    }

    public static org.apache.lucene.search.Query convertQuery(Query query) {
        Long maxDateTime;
        Long maxBytes;
        if (query.getStartDate() == null && query.getEndDate() == null && query.getSearchTerms().isEmpty()) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery luceneQuery = new BooleanQuery();
        for (SearchTerm searchTerm : query.getSearchTerms()) {
            String searchValue = searchTerm.getValue();
            if (searchValue == null) {
                throw new IllegalArgumentException("Empty search value not allowed (for term '" + searchTerm.getSearchableField().getFriendlyName() + "')");
            }
            if (searchValue.contains("*") || searchValue.contains("?")) {
                luceneQuery.add(new BooleanClause((org.apache.lucene.search.Query)new WildcardQuery(new Term(searchTerm.getSearchableField().getSearchableFieldName(), searchTerm.getValue().toLowerCase())), BooleanClause.Occur.MUST));
                continue;
            }
            luceneQuery.add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(searchTerm.getSearchableField().getSearchableFieldName(), searchTerm.getValue().toLowerCase())), BooleanClause.Occur.MUST));
        }
        Long minBytes = query.getMinFileSize() == null ? null : Long.valueOf(DataUnit.parseDataSize((String)query.getMinFileSize(), (DataUnit)DataUnit.B).longValue());
        Long l = maxBytes = query.getMaxFileSize() == null ? null : Long.valueOf(DataUnit.parseDataSize((String)query.getMaxFileSize(), (DataUnit)DataUnit.B).longValue());
        if (minBytes != null || maxBytes != null) {
            luceneQuery.add((org.apache.lucene.search.Query)NumericRangeQuery.newLongRange((String)SearchableFields.FileSize.getSearchableFieldName(), (Long)minBytes, (Long)maxBytes, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        Long minDateTime = query.getStartDate() == null ? null : Long.valueOf(query.getStartDate().getTime());
        Long l2 = maxDateTime = query.getEndDate() == null ? null : Long.valueOf(query.getEndDate().getTime());
        if (maxDateTime != null || minDateTime != null) {
            luceneQuery.add((org.apache.lucene.search.Query)NumericRangeQuery.newLongRange((String)SearchableFields.EventTime.getSearchableFieldName(), (Long)minDateTime, (Long)maxDateTime, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        }
        return luceneQuery;
    }

    public static void sortDocsForRetrieval(List<Document> documents) {
        Collections.sort(documents, new Comparator<Document>(){

            @Override
            public int compare(Document o1, Document o2) {
                String filename2;
                String filename1 = o1.get("storage-filename");
                int filenameComp = filename1.compareTo(filename2 = o2.get("storage-filename"));
                if (filenameComp != 0) {
                    return filenameComp;
                }
                IndexableField fileOffset1 = o1.getField("block-index");
                IndexableField fileOffset2 = o1.getField("block-index");
                if (fileOffset1 != null && fileOffset2 != null) {
                    int blockIndexResult = Long.compare(fileOffset1.numericValue().longValue(), fileOffset2.numericValue().longValue());
                    if (blockIndexResult != 0) {
                        return blockIndexResult;
                    }
                    long eventId1 = o1.getField(SearchableFields.Identifier.getSearchableFieldName()).numericValue().longValue();
                    long eventId2 = o2.getField(SearchableFields.Identifier.getSearchableFieldName()).numericValue().longValue();
                    return Long.compare(eventId1, eventId2);
                }
                long offset1 = o1.getField("storage-fileOffset").numericValue().longValue();
                long offset2 = o2.getField("storage-fileOffset").numericValue().longValue();
                return Long.compare(offset1, offset2);
            }
        });
    }

    public static Map<String, List<Document>> groupDocsByStorageFileName(List<Document> documents) {
        HashMap<String, List<Document>> documentGroups = new HashMap<String, List<Document>>();
        for (Document document : documents) {
            String fileName = document.get("storage-filename");
            if (!documentGroups.containsKey(fileName)) {
                documentGroups.put(fileName, new ArrayList());
            }
            ((List)documentGroups.get(fileName)).add(document);
        }
        for (List groupedDocuments : documentGroups.values()) {
            LuceneUtil.sortDocsForRetrieval(groupedDocuments);
        }
        return documentGroups;
    }

    public static String truncateIndexField(String field) {
        if (field == null) {
            return field;
        }
        Charset charset = Charset.defaultCharset();
        byte[] bytes = field.getBytes(charset);
        if (bytes.length <= 32766) {
            return field;
        }
        ByteBuffer bbuf = ByteBuffer.wrap(bytes, 0, 32766);
        try {
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.IGNORE);
            decoder.reset();
            CharBuffer cbuf = decoder.decode(bbuf);
            return cbuf.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }
}

