/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.nifi.provenance.RepositoryConfiguration;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.index.EventIndexWriter;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.apache.nifi.provenance.lucene.LuceneEventIndexSearcher;
import org.apache.nifi.provenance.lucene.LuceneEventIndexWriter;
import org.apache.nifi.provenance.lucene.LuceneUtil;
import org.apache.nifi.provenance.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleIndexManager
implements IndexManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleIndexManager.class);
    private final Map<File, IndexWriterCount> writerCounts = new HashMap<File, IndexWriterCount>();
    private final ExecutorService searchExecutor;
    private final RepositoryConfiguration repoConfig;

    public SimpleIndexManager(RepositoryConfiguration repoConfig) {
        this.repoConfig = repoConfig;
        this.searchExecutor = Executors.newFixedThreadPool(repoConfig.getQueryThreadPoolSize(), new NamedThreadFactory("Search Lucene Index", true));
    }

    @Override
    public void close() throws IOException {
        logger.debug("Shutting down SimpleIndexManager search executor");
        this.searchExecutor.shutdown();
        try {
            if (!this.searchExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.searchExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.searchExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventIndexSearcher borrowIndexSearcher(File indexDir) throws IOException {
        DirectoryReader directoryReader;
        IndexWriterCount writerCount;
        File absoluteFile = indexDir.getAbsoluteFile();
        Map<File, IndexWriterCount> map = this.writerCounts;
        synchronized (map) {
            writerCount = this.writerCounts.remove(absoluteFile);
            if (writerCount != null) {
                this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), writerCount.getCount() + 1, writerCount.isCloseableWhenUnused()));
            }
        }
        if (writerCount == null) {
            logger.trace("Creating index searcher for {}", (Object)indexDir);
            FSDirectory directory = FSDirectory.open((File)indexDir);
            directoryReader = DirectoryReader.open((Directory)directory);
        } else {
            EventIndexWriter eventIndexWriter = writerCount.getWriter();
            directoryReader = DirectoryReader.open((IndexWriter)eventIndexWriter.getIndexWriter(), (boolean)false);
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader, this.searchExecutor);
        logger.trace("Created index searcher {} for {}", (Object)searcher, (Object)indexDir);
        return new LuceneEventIndexSearcher(searcher, indexDir, null, directoryReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexSearcher(EventIndexSearcher searcher) {
        IndexWriterCount count;
        File indexDirectory = searcher.getIndexDirectory();
        logger.debug("Closing index searcher {} for {}", (Object)searcher, (Object)indexDirectory);
        SimpleIndexManager.closeQuietly(searcher);
        logger.debug("Closed index searcher {}", (Object)searcher);
        boolean closeWriter = false;
        Map<File, IndexWriterCount> map = this.writerCounts;
        synchronized (map) {
            File absoluteFile = searcher.getIndexDirectory().getAbsoluteFile();
            count = this.writerCounts.get(absoluteFile);
            if (count == null) {
                logger.debug("Returning EventIndexSearcher for {}; there is no active writer for this searcher so will not decrement writerCounts", (Object)absoluteFile);
                return;
            }
            if (count.getCount() <= 1) {
                boolean close = count.isCloseableWhenUnused();
                logger.debug("Decrementing count for Index Writer for {} to {}{}", new Object[]{indexDirectory, count.getCount() - 1, close ? "; closing writer" : ""});
                if (close) {
                    this.writerCounts.remove(absoluteFile);
                    closeWriter = true;
                } else {
                    this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, count.isCloseableWhenUnused()));
                }
            } else {
                this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, count.isCloseableWhenUnused()));
            }
        }
        if (closeWriter) {
            try {
                this.close(count);
            }
            catch (Exception e) {
                logger.warn("Failed to close Index Writer {} due to {}", new Object[]{count.getWriter(), e.toString(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeIndex(File indexDirectory) {
        IndexWriterCount writerCount;
        File absoluteFile = indexDirectory.getAbsoluteFile();
        logger.debug("Attempting to remove index {} from SimpleIndexManager", (Object)absoluteFile);
        Map<File, IndexWriterCount> map = this.writerCounts;
        synchronized (map) {
            writerCount = this.writerCounts.remove(absoluteFile);
            if (writerCount == null) {
                logger.debug("Allowing removal of index {} because there is no IndexWriterCount for this directory", (Object)absoluteFile);
                return true;
            }
            if (writerCount.getCount() > 0) {
                logger.debug("Not allowing removal of index {} because the active writer count for this directory is {}", (Object)absoluteFile, (Object)writerCount.getCount());
                this.writerCounts.put(absoluteFile, writerCount);
                return false;
            }
        }
        try {
            logger.debug("Removing index {} from SimpleIndexManager and closing the writer", (Object)absoluteFile);
            this.close(writerCount);
        }
        catch (Exception e) {
            logger.error("Failed to close Index Writer for {} while removing Index from the repository;this directory may need to be cleaned up manually.", (Throwable)e);
        }
        return true;
    }

    private IndexWriterCount createWriter(File indexDirectory) throws IOException {
        ArrayList<Object> closeables = new ArrayList<Object>();
        FSDirectory directory = FSDirectory.open((File)indexDirectory);
        closeables.add(directory);
        try {
            StandardAnalyzer analyzer = new StandardAnalyzer();
            closeables.add(analyzer);
            IndexWriterConfig config = new IndexWriterConfig(LuceneUtil.LUCENE_VERSION, (Analyzer)analyzer);
            ConcurrentMergeScheduler concurrentMergeScheduler = new ConcurrentMergeScheduler();
            int mergeThreads = this.repoConfig.getConcurrentMergeThreads();
            concurrentMergeScheduler.setMaxMergesAndThreads(mergeThreads, mergeThreads);
            config.setMergeScheduler((MergeScheduler)concurrentMergeScheduler);
            IndexWriter indexWriter = new IndexWriter((Directory)directory, config);
            LuceneEventIndexWriter eventIndexWriter = new LuceneEventIndexWriter(indexWriter, indexDirectory);
            IndexWriterCount writerCount = new IndexWriterCount(eventIndexWriter, (Analyzer)analyzer, (Directory)directory, 1, false);
            logger.debug("Providing new index writer for {}", (Object)indexDirectory);
            return writerCount;
        }
        catch (IOException ioe) {
            for (Closeable closeable : closeables) {
                try {
                    closeable.close();
                }
                catch (IOException ioe2) {
                    ioe.addSuppressed(ioe2);
                }
            }
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventIndexWriter borrowIndexWriter(File indexDirectory) throws IOException {
        File absoluteFile = indexDirectory.getAbsoluteFile();
        logger.trace("Borrowing index writer for {}", (Object)indexDirectory);
        IndexWriterCount writerCount = null;
        Map<File, IndexWriterCount> map = this.writerCounts;
        synchronized (map) {
            writerCount = this.writerCounts.get(absoluteFile);
            if (writerCount == null) {
                writerCount = this.createWriter(indexDirectory);
                this.writerCounts.put(absoluteFile, writerCount);
            } else {
                logger.trace("Providing existing index writer for {} and incrementing count to {}", (Object)indexDirectory, (Object)(writerCount.getCount() + 1));
                this.writerCounts.put(absoluteFile, new IndexWriterCount(writerCount.getWriter(), writerCount.getAnalyzer(), writerCount.getDirectory(), writerCount.getCount() + 1, writerCount.isCloseableWhenUnused()));
            }
            if (this.writerCounts.size() > this.repoConfig.getStorageDirectories().size() * 2) {
                logger.debug("Index Writer returned; writer count map now has size {}; writerCount = {}; full writerCounts map = {}", new Object[]{this.writerCounts.size(), writerCount, this.writerCounts});
            }
        }
        return writerCount.getWriter();
    }

    @Override
    public void returnIndexWriter(EventIndexWriter writer) {
        this.returnIndexWriter(writer, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnIndexWriter(EventIndexWriter writer, boolean commit, boolean isCloseable) {
        block20: {
            File indexDirectory = writer.getDirectory();
            File absoluteFile = indexDirectory.getAbsoluteFile();
            logger.trace("Returning Index Writer for {} to IndexManager", (Object)indexDirectory);
            boolean unused = false;
            IndexWriterCount count = null;
            boolean close = isCloseable;
            try {
                Map<File, IndexWriterCount> map = this.writerCounts;
                synchronized (map) {
                    count = this.writerCounts.get(absoluteFile);
                    if (count != null && count.isCloseableWhenUnused()) {
                        close = true;
                    }
                    if (count == null) {
                        logger.warn("Index Writer {} was returned to IndexManager for {}, but this writer is not known. This could potentially lead to a resource leak", (Object)writer, (Object)indexDirectory);
                        writer.close();
                    } else if (count.getCount() <= 1) {
                        unused = true;
                        if (close) {
                            logger.debug("Decrementing count for Index Writer for {} to {}; closing writer", (Object)indexDirectory, (Object)(count.getCount() - 1));
                            this.writerCounts.remove(absoluteFile);
                        } else {
                            logger.trace("Decrementing count for Index Writer for {} to {}", (Object)indexDirectory, (Object)(count.getCount() - 1));
                            this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, close));
                        }
                    } else {
                        if (close) {
                            logger.debug("Decrementing count for Index Writer for {} to {} and marking as closeable when no longer in use", (Object)indexDirectory, (Object)(count.getCount() - 1));
                        } else {
                            logger.trace("Decrementing count for Index Writer for {} to {}", (Object)indexDirectory, (Object)(count.getCount() - 1));
                        }
                        this.writerCounts.put(absoluteFile, new IndexWriterCount(count.getWriter(), count.getAnalyzer(), count.getDirectory(), count.getCount() - 1, close));
                    }
                    if (this.writerCounts.size() > this.repoConfig.getStorageDirectories().size() * 2) {
                        logger.debug("Index Writer returned; writer count map now has size {}; writer = {}, commit = {}, isCloseable = {}, writerCount = {}; full writerCounts Map = {}", new Object[]{this.writerCounts.size(), writer, commit, isCloseable, count, this.writerCounts});
                    }
                }
                if (!unused) break block20;
                try {
                    if (commit) {
                        writer.commit();
                    }
                }
                finally {
                    if (close) {
                        logger.info("Index Writer for {} has been returned to Index Manager and is no longer in use. Closing Index Writer", (Object)indexDirectory);
                        this.close(count);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Failed to close Index Writer {} due to {}", new Object[]{writer, e.toString(), e});
            }
        }
    }

    protected void close(IndexWriterCount count) throws IOException {
        logger.debug("Closing Index Writer for {}...", (Object)count.getWriter().getDirectory());
        count.close();
        logger.debug("Finished closing Index Writer for {}...", (Object)count.getWriter().getDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getWriterCount() {
        Map<File, IndexWriterCount> map = this.writerCounts;
        synchronized (map) {
            return this.writerCounts.size();
        }
    }

    private static void closeQuietly(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close {} due to {}", (Object)closeable, (Object)e);
            }
        }
    }

    protected static class IndexWriterCount
    implements Closeable {
        private final EventIndexWriter writer;
        private final Analyzer analyzer;
        private final Directory directory;
        private final int count;
        private final boolean closeableWhenUnused;

        public IndexWriterCount(EventIndexWriter writer, Analyzer analyzer, Directory directory, int count, boolean closeableWhenUnused) {
            this.writer = writer;
            this.analyzer = analyzer;
            this.directory = directory;
            this.count = count;
            this.closeableWhenUnused = closeableWhenUnused;
        }

        public boolean isCloseableWhenUnused() {
            return this.closeableWhenUnused;
        }

        public Analyzer getAnalyzer() {
            return this.analyzer;
        }

        public Directory getDirectory() {
            return this.directory;
        }

        public EventIndexWriter getWriter() {
            return this.writer;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void close() throws IOException {
            SimpleIndexManager.closeQuietly(new Closeable[]{this.writer, this.analyzer, this.directory});
        }

        public String toString() {
            return "IndexWriterCount[count=" + this.count + ", writer=" + this.writer + ", closeableWhenUnused=" + this.closeableWhenUnused + "]";
        }
    }
}

