/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.nifi.provenance.IndexConfiguration;
import org.apache.nifi.provenance.expiration.ExpirationAction;
import org.apache.nifi.provenance.serialization.RecordReader;
import org.apache.nifi.provenance.serialization.RecordReaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMinimumEventId
implements ExpirationAction {
    private static final Logger logger = LoggerFactory.getLogger(UpdateMinimumEventId.class);
    private final IndexConfiguration indexConfig;

    public UpdateMinimumEventId(IndexConfiguration indexConfig) {
        this.indexConfig = indexConfig;
    }

    @Override
    public File execute(File expiredFile) throws IOException {
        try (RecordReader reader = RecordReaders.newRecordReader(expiredFile, null, Integer.MAX_VALUE);){
            long maxEventId = reader.getMaxEventId();
            this.indexConfig.setMinIdIndexed(maxEventId);
            logger.info("Updated Minimum Event ID for Provenance Event Repository - Minimum Event ID now {}", (Object)maxEventId);
        }
        catch (IOException ioe) {
            logger.warn("Failed to obtain max ID present in journal file {}", (Object)expiredFile.getAbsolutePath());
        }
        return expiredFile;
    }

    @Override
    public boolean hasBeenPerformed(File expiredFile) throws IOException {
        return !expiredFile.exists();
    }
}

