/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.serialization;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.AbstractRecordWriter;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.serialization.StorageSummary;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.stream.io.NonCloseableOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompressableRecordWriter
extends AbstractRecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(CompressableRecordWriter.class);
    private final FileOutputStream fos;
    private final ByteCountingOutputStream rawOutStream;
    private final boolean compressed;
    private final int uncompressedBlockSize;
    private final AtomicLong idGenerator;
    private DataOutputStream out;
    private ByteCountingOutputStream byteCountingOut;
    private long blockStartOffset = 0L;
    private int recordCount = 0;

    public CompressableRecordWriter(File file, AtomicLong idGenerator, TocWriter writer, boolean compressed, int uncompressedBlockSize) throws IOException {
        super(file, writer);
        logger.trace("Creating Record Writer for {}", (Object)file.getName());
        this.compressed = compressed;
        this.fos = new FileOutputStream(file);
        this.rawOutStream = new ByteCountingOutputStream((OutputStream)new BufferedOutputStream(this.fos));
        this.uncompressedBlockSize = uncompressedBlockSize;
        this.idGenerator = idGenerator;
    }

    public CompressableRecordWriter(OutputStream out, String storageLocation, AtomicLong idGenerator, TocWriter tocWriter, boolean compressed, int uncompressedBlockSize) throws IOException {
        super(storageLocation, tocWriter);
        this.fos = null;
        this.compressed = compressed;
        this.uncompressedBlockSize = uncompressedBlockSize;
        this.rawOutStream = new ByteCountingOutputStream((OutputStream)new BufferedOutputStream(out));
        this.idGenerator = idGenerator;
    }

    protected AtomicLong getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public synchronized void writeHeader(long firstEventId) throws IOException {
        if (this.isDirty()) {
            throw new IOException("Cannot update Provenance Repository because this Record Writer has already failed to write to the Repository");
        }
        try {
            this.blockStartOffset = this.rawOutStream.getBytesWritten();
            this.resetWriteStream(firstEventId);
            this.out.writeUTF(this.getSerializationName());
            this.out.writeInt(this.getSerializationVersion());
            this.writeHeader(firstEventId, this.out);
            this.out.flush();
            this.blockStartOffset = this.getBytesWritten();
        }
        catch (IOException ioe) {
            this.markDirty();
            throw ioe;
        }
    }

    protected void resetWriteStream(Long eventId) throws IOException {
        try {
            if (this.out != null) {
                this.out.flush();
            }
            long byteOffset = this.byteCountingOut == null ? this.rawOutStream.getBytesWritten() : this.byteCountingOut.getBytesWritten();
            TocWriter tocWriter = this.getTocWriter();
            if (this.compressed) {
                if (this.out != null) {
                    this.out.close();
                }
                if (tocWriter != null && eventId != null) {
                    tocWriter.addBlockOffset(this.rawOutStream.getBytesWritten(), eventId);
                }
                BufferedOutputStream writableStream = new BufferedOutputStream((OutputStream)new GZIPOutputStream((OutputStream)new NonCloseableOutputStream((OutputStream)this.rawOutStream), 1), 65536);
                this.byteCountingOut = new ByteCountingOutputStream((OutputStream)writableStream, byteOffset);
            } else {
                if (tocWriter != null && eventId != null) {
                    tocWriter.addBlockOffset(this.rawOutStream.getBytesWritten(), eventId);
                }
                this.byteCountingOut = this.rawOutStream;
            }
            this.out = new DataOutputStream((OutputStream)this.byteCountingOut);
            this.resetDirtyFlag();
        }
        catch (IOException ioe) {
            this.markDirty();
            throw ioe;
        }
    }

    protected synchronized void ensureStreamState(long recordIdentifier, long startBytes) throws IOException {
        if (this.getTocWriter() != null && startBytes - this.blockStartOffset >= (long)this.uncompressedBlockSize) {
            this.blockStartOffset = startBytes;
            this.resetWriteStream(recordIdentifier);
        }
    }

    @Override
    public synchronized StorageSummary writeRecord(ProvenanceEventRecord record) throws IOException {
        if (this.isDirty()) {
            throw new IOException("Cannot update Provenance Repository because this Record Writer has already failed to write to the Repository");
        }
        try {
            long recordIdentifier = record.getEventId() == -1L ? this.idGenerator.getAndIncrement() : record.getEventId();
            long startBytes = this.byteCountingOut.getBytesWritten();
            this.ensureStreamState(recordIdentifier, startBytes);
            this.writeRecord(record, recordIdentifier, this.out);
            ++this.recordCount;
            long bytesWritten = this.byteCountingOut.getBytesWritten();
            long serializedLength = bytesWritten - startBytes;
            TocWriter tocWriter = this.getTocWriter();
            Integer blockIndex = tocWriter == null ? null : Integer.valueOf(tocWriter.getCurrentBlockIndex());
            String storageLocation = this.getStorageLocation();
            return new StorageSummary(recordIdentifier, storageLocation, blockIndex, serializedLength, bytesWritten);
        }
        catch (IOException ioe) {
            this.markDirty();
            throw ioe;
        }
    }

    @Override
    public synchronized long getBytesWritten() {
        return this.byteCountingOut == null ? 0L : this.byteCountingOut.getBytesWritten();
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public synchronized int getRecordsWritten() {
        return this.recordCount;
    }

    @Override
    protected synchronized DataOutputStream getBufferedOutputStream() {
        return this.out;
    }

    @Override
    protected synchronized OutputStream getUnderlyingOutputStream() {
        return this.fos;
    }

    @Override
    protected synchronized void syncUnderlyingOutputStream() throws IOException {
        if (this.fos != null) {
            this.fos.getFD().sync();
        }
    }

    protected boolean isCompressed() {
        return this.compressed;
    }

    protected abstract void writeRecord(ProvenanceEventRecord var1, long var2, DataOutputStream var4) throws IOException;

    protected abstract void writeHeader(long var1, DataOutputStream var3) throws IOException;

    protected abstract int getSerializationVersion();

    protected abstract String getSerializationName();
}

