/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.serialization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.provenance.store.EventFileManager;
import org.apache.nifi.provenance.toc.StandardTocReader;
import org.apache.nifi.provenance.toc.StandardTocWriter;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.provenance.toc.TocUtil;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.provenance.util.CloseableUtil;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.stream.io.NonCloseableOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFileCompressor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EventFileCompressor.class);
    private final BlockingQueue<File> filesToCompress;
    private final EventFileManager eventFileManager;
    private volatile boolean shutdown = false;

    public EventFileCompressor(BlockingQueue<File> filesToCompress, EventFileManager eventFileManager) {
        this.filesToCompress = filesToCompress;
        this.eventFileManager = eventFileManager;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            File uncompressedEventFile = null;
            try {
                long start = System.nanoTime();
                uncompressedEventFile = this.filesToCompress.poll(1L, TimeUnit.SECONDS);
                if (uncompressedEventFile == null || this.shutdown) continue;
                File outputFile = null;
                long bytesBefore = 0L;
                StandardTocReader tocReader = null;
                File tmpTocFile = null;
                this.eventFileManager.obtainReadLock(uncompressedEventFile);
                StandardTocWriter tocWriter = null;
                File tocFile = TocUtil.getTocFile(uncompressedEventFile);
                try {
                    tocReader = new StandardTocReader(tocFile);
                }
                catch (IOException e) {
                    logger.error("Failed to read TOC File {}", (Object)tocFile, (Object)e);
                    this.eventFileManager.releaseReadLock(uncompressedEventFile);
                    continue;
                }
                try {
                    bytesBefore = uncompressedEventFile.length();
                    try {
                        outputFile = new File(uncompressedEventFile.getParentFile(), uncompressedEventFile.getName() + ".gz");
                        try {
                            tmpTocFile = new File(tocFile.getParentFile(), tocFile.getName() + ".tmp");
                            tocWriter = new StandardTocWriter(tmpTocFile, true, false);
                            EventFileCompressor.compress(uncompressedEventFile, tocReader, outputFile, tocWriter);
                            tocWriter.close();
                        }
                        catch (IOException ioe) {
                            logger.error("Failed to compress {} on rollover", (Object)uncompressedEventFile, (Object)ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        CloseableUtil.closeQuietly(tocReader, tocWriter);
                        throw throwable;
                    }
                    CloseableUtil.closeQuietly(tocReader, tocWriter);
                }
                finally {
                    this.eventFileManager.releaseReadLock(uncompressedEventFile);
                }
                this.eventFileManager.obtainWriteLock(uncompressedEventFile);
                try {
                    if (uncompressedEventFile.delete()) {
                        if (tocReader != null) {
                            File tocFile2 = tocReader.getFile();
                            if (!tocFile2.delete()) {
                                logger.warn("Failed to delete {}; this file should be cleaned up manually", (Object)tocFile2);
                            }
                            if (tmpTocFile != null) {
                                tmpTocFile.renameTo(tocFile2);
                            }
                        }
                    } else {
                        logger.warn("Failed to delete {}; this file should be cleaned up manually", (Object)uncompressedEventFile);
                    }
                }
                finally {
                    this.eventFileManager.releaseWriteLock(uncompressedEventFile);
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                long bytesAfter = outputFile.length();
                double reduction = 100.0 * (1.0 - (double)bytesAfter / (double)bytesBefore);
                String reductionTwoDecimals = String.format("%.2f", reduction);
                logger.debug("Successfully compressed Provenance Event File {} in {} millis from {} to {}, a reduction of {}%", new Object[]{uncompressedEventFile, millis, FormatUtils.formatDataSize((double)bytesBefore), FormatUtils.formatDataSize((double)bytesAfter), reductionTwoDecimals});
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (Exception e) {
                logger.error("Failed to compress {}", uncompressedEventFile, (Object)e);
            }
        }
    }

    public static void compress(File input, TocReader tocReader, File output, TocWriter tocWriter) throws IOException {
        try (FileInputStream fis = new FileInputStream(input);
             FileOutputStream fos = new FileOutputStream(output);
             ByteCountingOutputStream byteCountingOut = new ByteCountingOutputStream((OutputStream)fos);){
            long blockStart;
            int blockIndex = 0;
            while ((blockStart = tocReader.getBlockOffset(blockIndex)) != -1L) {
                long blockEnd = tocReader.getBlockOffset(blockIndex + 1);
                if (blockEnd < 0L) {
                    blockEnd = input.length();
                }
                long firstEventId = tocReader.getFirstEventIdForBlock(blockIndex);
                long blockStartOffset = byteCountingOut.getBytesWritten();
                try (NonCloseableOutputStream ncos = new NonCloseableOutputStream((OutputStream)byteCountingOut);
                     GZIPOutputStream gzipOut = new GZIPOutputStream((OutputStream)ncos, 1);){
                    StreamUtils.copy((InputStream)fis, (OutputStream)gzipOut, (long)(blockEnd - blockStart));
                }
                tocWriter.addBlockOffset(blockStartOffset, firstEventId);
                ++blockIndex;
            }
        }
        CloseableUtil.closeQuietly(tocReader, tocWriter);
    }
}

