/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store;

import org.apache.nifi.provenance.serialization.RecordWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordWriterLease {
    private final Logger logger = LoggerFactory.getLogger(RecordWriterLease.class);
    private final RecordWriter writer;
    private final long maxBytes;
    private final int maxEvents;
    private long usageCounter;
    private boolean markedRollable = false;
    private boolean closed = false;

    public RecordWriterLease(RecordWriter writer, long maxBytes) {
        this(writer, maxBytes, Integer.MAX_VALUE);
    }

    public RecordWriterLease(RecordWriter writer, long maxBytes, int maxEvents) {
        this.writer = writer;
        this.maxBytes = maxBytes;
        this.maxEvents = maxEvents;
    }

    public RecordWriter getWriter() {
        return this.writer;
    }

    public synchronized boolean tryClaim() {
        if (this.markedRollable || this.writer.isClosed() || this.writer.isDirty() || this.writer.getBytesWritten() >= this.maxBytes || this.writer.getRecordsWritten() >= this.maxEvents) {
            return false;
        }
        ++this.usageCounter;
        return true;
    }

    public synchronized void relinquishClaim() {
        --this.usageCounter;
        if (this.closed && this.usageCounter < 1L) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close " + this.writer, (Throwable)e);
            }
        }
    }

    public synchronized boolean shouldRoll() {
        if (this.markedRollable) {
            return true;
        }
        if (this.usageCounter < 1L && (this.writer.isClosed() || this.writer.isDirty() || this.writer.getBytesWritten() >= this.maxBytes || this.writer.getRecordsWritten() >= this.maxEvents)) {
            this.markedRollable = true;
            return true;
        }
        return false;
    }

    public synchronized void close() {
        this.closed = true;
        if (this.usageCounter < 1L) {
            try {
                this.writer.close();
            }
            catch (Exception e) {
                this.logger.warn("Failed to close " + this.writer, (Throwable)e);
            }
        }
    }
}

