/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store.iterator;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import org.apache.nifi.provenance.ProvenanceEventRecord;

public interface EventIterator
extends Closeable {
    public static final EventIterator EMPTY = new EventIterator(){

        @Override
        public void close() throws IOException {
        }

        @Override
        public Optional<ProvenanceEventRecord> nextEvent() {
            return Optional.empty();
        }
    };

    public Optional<ProvenanceEventRecord> nextEvent() throws IOException;

    public static EventIterator of(ProvenanceEventRecord ... events) {
        final Iterator<ProvenanceEventRecord> itr = Arrays.asList(events).iterator();
        return new EventIterator(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public Optional<ProvenanceEventRecord> nextEvent() {
                return itr.hasNext() ? Optional.empty() : Optional.of(itr.next());
            }
        };
    }
}

