/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.nifi.provenance.util.ByteArrayDataOutputStream;

public class ByteArrayDataOutputStreamCache {
    private final BlockingQueue<ByteArrayDataOutputStream> queue;
    private final int initialBufferSize;
    private final int maxBufferSize;

    public ByteArrayDataOutputStreamCache(int maxCapacity, int initialBufferSize, int maxBufferSize) {
        this.queue = new LinkedBlockingQueue<ByteArrayDataOutputStream>(maxCapacity);
        this.initialBufferSize = initialBufferSize;
        this.maxBufferSize = maxBufferSize;
    }

    public ByteArrayDataOutputStream checkOut() {
        ByteArrayDataOutputStream stream = (ByteArrayDataOutputStream)this.queue.poll();
        if (stream != null) {
            return stream;
        }
        return new ByteArrayDataOutputStream(this.initialBufferSize);
    }

    public void checkIn(ByteArrayDataOutputStream bados) {
        int size = bados.getByteArrayOutputStream().size();
        if (size > this.maxBufferSize) {
            return;
        }
        bados.getByteArrayOutputStream().reset();
        this.queue.offer(bados);
    }
}

