/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.util;

import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableUtil {
    private static final Logger logger = LoggerFactory.getLogger(CloseableUtil.class);

    public static void closeQuietly(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("Failed to close {}; sources resources may not be cleaned up appropriately.", (Object)closeable, (Object)e);
                    continue;
                }
                logger.warn("Failed to close {}; sources resources may not be cleaned up appropriately.", (Object)closeable);
            }
        }
    }
}

