/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.util;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.provenance.RepositoryConfiguration;

public class DirectoryUtils {
    public static final FileFilter EVENT_FILE_FILTER = f -> f.getName().endsWith(".prov") || f.getName().endsWith(".prov.gz");
    public static final FileFilter INDEX_FILE_FILTER = f -> f.getName().startsWith("index-");
    public static final Comparator<File> SMALLEST_ID_FIRST = (a, b) -> Long.compare(DirectoryUtils.getMinId(a), DirectoryUtils.getMinId(b));
    public static final Comparator<File> LARGEST_ID_FIRST = SMALLEST_ID_FIRST.reversed();
    public static final Comparator<File> OLDEST_INDEX_FIRST = (a, b) -> Long.compare(DirectoryUtils.getIndexTimestamp(a), DirectoryUtils.getIndexTimestamp(b));
    public static final Comparator<File> NEWEST_INDEX_FIRST = OLDEST_INDEX_FIRST.reversed();

    public static List<Path> getProvenanceEventFiles(RepositoryConfiguration repoConfig) {
        return repoConfig.getStorageDirectories().values().stream().flatMap(f -> {
            File[] eventFiles = f.listFiles(EVENT_FILE_FILTER);
            return eventFiles == null ? Stream.empty() : Arrays.stream(eventFiles);
        }).map(f -> f.toPath()).collect(Collectors.toList());
    }

    public static long getMinId(File file) {
        String filename = file.getName();
        int firstDotIndex = filename.indexOf(".");
        if (firstDotIndex < 1) {
            return -1L;
        }
        String firstEventId = filename.substring(0, firstDotIndex);
        try {
            return Long.parseLong(firstEventId);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static long getIndexTimestamp(File file) {
        String filename = file.getName();
        if (!filename.startsWith("index-") && filename.length() > 6) {
            return -1L;
        }
        String suffix = filename.substring(6);
        try {
            return Long.parseLong(suffix);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    public static long getSize(File file) {
        if (file.isFile()) {
            return file.length();
        }
        File[] children = file.listFiles();
        if (children == null || children.length == 0) {
            return 0L;
        }
        long total = 0L;
        for (File child : children) {
            total += DirectoryUtils.getSize(child);
        }
        return total;
    }
}

